import Config from '../config'
import CmdLine from '../lib/cmd-line'
import FileSystem from '../lib/file-system'
import Logger from '../lib/logger'

exports.command = ['run', '*']
exports.desc = 'Runs Smoca test.'
exports.builder = {
  d: {
    default: undefined,
    alias: 'dir',
    type: 'string'
  },
  p: {
    default: false,
    alias: 'parallel',
    type: 'boolean'
  },
  n: {
    default: undefined,
    alias: 'max-processes',
    type: 'number'
  },
  l: {
    default: undefined,
    alias: 'runtime-log',
    type: 'string'
  }
}
exports.handler = function (argv) {
  Config.setSmocaDir(argv.dir)
  if (!FileSystem.doesDirExist(Config.smocaDirPath)) {
    Logger.error(`Smoca dir not found:\n  ${Config.smocaDirPath}\nUse 'init' to create one.`)
    return
  }

  let command

  if (argv.parallel) {
    command = 'parallel_rspec'
    if (argv.maxProcesses) { // The max processes to run in parallel
      command += ` -n ${argv.maxProcesses}`
    }
    if (argv.runtimeLog) { // Runtime log durations
      command += ` --runtime-log ${argv.runtimeLog}`
    }
  } else {
    command = 'rspec'
  }

  CmdLine.runCmd(`bundle exec ${command} spec/`, Config.smocaDirPath)
}
