import FileSystem from './lib/file-system'
import Logger from './lib/logger'

export default class Config {
  static setSmocaDir (customDirPath) {
    if (customDirPath === undefined) {
      return
    }
    if (!FileSystem.doesDirExist(customDirPath)) {
      Logger.error(`Directory doesn't exist:\n  ${customDirPath}\n`)
      return
    }
    if (!customDirPath.endsWith('/')) {
      customDirPath += '/'
    }
    Config.smocaDirPath = customDirPath + 'smoca/'
  }

  static setSmocaVersion (customVersion) {
    if (customVersion === undefined) {
      return
    }
    Config.smocaVersion = customVersion
  }
}

Config.smocaDirName = 'smoca'
Config.smocaDirPath = process.cwd() + '/' + Config.smocaDirName + '/'
Config.rubyVersion = '2.3.1'
Config.smocaVersion = undefined
