import colors from 'colors'

export default class Logger {
  static warn (msg) {
    console.log(colors.yellow(msg))
  }

  static error (msg, doExit) {
    console.log(colors.red(msg))
    if (doExit) {
      process.exit(1)
    }
  }

  static progress (msg) {
    console.log(colors.magenta(msg))
  }
}
