Smoca is a Black-box GUI automated test suite developed and maintained by Quality Engineering.
It is built with Selenium, RSpec and Capybara.

Traditionally, the Smoca Framework and Tests lived together in qa/smoca.
This project aims to deliver the Smoca Framework as a package, and your Smoca tests can live within individual repositories.

**This project should be considered Experimental and In Beta**

# Quick Start

We have created an [Examples Directory](/examples). You can drag the Smoca folder (within examples) into your repository.

Google Chrome is the default browser Smoca uses.
You must have [Google Chrome](https://www.google.com/chrome/index.html) installed.

### Manual

#### Set Up Folder Structure

An ideal tree will be

```
<Your Repository>
- Smoca/
  - spec/
    - spec_helper.rb
  - .ruby-version
  - Gemfile
```

Let's set this up:

At the root of your repository:

```
mkdir smoca
```

```
cd smoca
```

```
mkdir spec
```

### Specific Smoca Configuration

Set your ruby version
```
echo "2.3.1" > .ruby-version
```

Create your Gemfile

<your_repo>/smoca/Gemfile
```
source 'http://rubygems.org'

source 'https://gem.internal.justin.tv' do
  gem 'smoca', '~> 0.6.0'
end
```

Create a spec_helper (for your test configuration)

<your_repo>/smoca/spec/spec_helper.rb
```
require 'smoca'

Smoca.app_host = 'https://www.twitch.tv/'
```

Create your first test:

<your_repo>/smoca/spec/my_first_spec.rb
```
require 'spec_helper.rb'

feature 'Front Page' do
  
  scenario 'can navigate to' do
    visit '/'
    
    expect(page).to have_css '#front_page_body'
  end
end

```

### Setting up your Environment
You need to have Ruby and the necessary packages installed to run.

Refer to [Developing for Smoca](https://git-aws.internal.justin.tv/qa/smoca/blob/master/resources/docs/developing_for_smoca.md#preparing-your-environment).

### Running

Make sure you are in the `<your_app>/smoca` directory

```
bundle exec rspec
```

# DSL

## Configuring Drivers

Smoca supports two different classes of driver registrations: Local and Remote. Each are described below.

### Local
Local initiates a local session on your machine. A browser will open up and run.

Within spec_helper.rb:
```
Smoca::Driver::Local.initialize
```
  
#### Capabilities

The browser can be passed directly to the Local Driver initialization as a symbol.

Currently the only supported browser is Firefox.

```
Smoca::Driver::Local.initialize(browser: :firefox)
```

### Remote

Remote initiates a session on a remote machine.

Unlike local, you must initiate a capabilities object and pass that to the driver initialization. More detail below.

Within spec_helper.rb
```
caps = Smoca::Driver::RemoteCapabilities.new
Smoca::Driver::Remote.initialize(caps)
```

The following option parameters can be passed to the `Smoca::Driver::Remote.initialize()` method:
- remote_type
  - Symbol. The type of remote connection to use. Supports :internal, :internal_dev or :saucelabs
- access_id
  - String. The Sauce Labs access id / username. Required if passing remote_time :saucelabs
- access_key
  - String. The Sauce Labs access key. Required if passing remote_time :saucelabs

#### Capabilities
This is used for specifying Browser & OS.

The `Smoca::Driver::RemoteCapabilities.new` class takes the following option parameters:

- :platform
  - String: The operating system platform to run on, i.e., Windows 10
- :browser_name
  - Symbol: The browser name to use, i.e., :firefox
- :version
  - String or Int: The browser version to use, i.e., 47

# Options

### Retry Support

Smoca-core supports retrying examples. Pass the number of retries you'd like via environment variable RETRY_COUNT.

Example:

`RETRY_COUNT=5 bundle exec rspec`

### Screenshot Support

Smoca-core will automatically take a screenshot when a failed expectation is encountered.

Required Environment Variables:
- `SCREENSHOTS=true`
- `DROPBOX_TOKEN=my_token`
  - Supplying `SCREENSHOTS` without `DROPBOX_TOKEN` will return a local file

Screenshots will output to the directory `resources/output/failures/<date>/`
