require 'spec_helper' # This must be included in every spec file

feature 'Front Page' do

  before(:each) do
    # This gets ran before each scenario. It's not required to include.
    visit '/'
  end

  scenario 'displays top bar' do
    expect(page).to have_css '#site_header'
  end

  scenario 'displays featured games' do
    expect(page).to have_css '#games'

    within '#games' do
      # within narrows your scope of css/content expectations.
      # Useful if you had "Log In" in two different areas of the page.
      expect(page).to have_content 'Featured Games'
      expect(page).to have_css('.js-directory-game', count: 12)
    end

  end
end