require_relative 'properties'
require_relative '../driver/remote'
require_relative '../driver/local'
require_relative '../driver/remote_capabilities'

module Smoca
  class Configuration
    class Driver
      class << self

        # Initializes a driver instance either on remote or grid
        def initialize
          Smoca::Properties.grid ? initialize_remote : initialize_local
        end

        # Initializes a Remote Connection
        private def initialize_remote
          puts '[INFO] Running Smoca on Remote Grid'
          caps = Smoca::Driver::RemoteCapabilities.new(
            platform: Smoca::Properties.os_platform,
            os_version: Smoca::Properties.os_version,
            browser_name: Smoca::Properties.browser_name,
            version: Smoca::Properties.browser_version,
            screen_resolution: Smoca::Properties.screen_resolution,
            tunnelIdentifier: Smoca::Properties.sauce_tunnel_identifier
          )

          Smoca::Driver::Remote.initialize(
            caps,
            remote_type: Smoca::Properties.grid_host,
            access_id: Smoca::Properties.saucelabs_username,
            access_key: Smoca::Properties.saucelabs_access_key
          )
        end

        # Initializes a Local Connection
        private def initialize_local
          puts '[INFO] Running Smoca locally'
          Smoca::Driver::Local.initialize
        end

      end
    end
  end
end
