require_relative 'base'

module Smoca
  class Driver
    class Local < Base

      class << self
        DEFAULT_OPTIONS = { browser: :chrome }.freeze
        SUPPORTED_BROWSERS = [:firefox, :chrome].freeze

        # @param opts [Hash] Options to initialize the driver with
        # @option opts [Symbol] :browser (:chrome) The browser run with. See SUPPORTED_BROWSERS for options.
        def initialize(opts={})
          @options = DEFAULT_OPTIONS.merge(opts)
          @browser = @options[:browser]
          register_driver(driver_opts)
        end

        # @return [Hash] The formatted driver options for Capybara
        private def driver_opts
          driver_options = {}

          unless SUPPORTED_BROWSERS.include?(@browser)
            raise Error::NotYetImplemented, "#{@browser} is not yet supported."\
                                            " Supported Browsers: #{SUPPORTED_BROWSERS.to_s}"
          end

          driver_options[:browser] = @browser

          if @browser == :firefox
            # Marionette Support not yet included for Firefox
            driver_options[:desired_capabilities] = Selenium::WebDriver::Remote::Capabilities.firefox(marionette: false)
          end

          return driver_options
        end
      end

    end
  end
end
