module Smoca
  class Driver
    class RemoteCapabilities
      attr_reader :caps

      DEFAULT_OPTS = {
        platform: :linux,
        os_version: nil,
        browser_name: :firefox,
        version: nil,
        tunnelIdentifier: nil # Used for Sauce Labs
      }.freeze

      # @param opts [Hash] Options to provide to the capabilities
      # @option opts [Symbol] platform (:linux) The platform to run on
      # @option opts [Symbol] browser_name (:firefox) The browser to run on
      # @option opts [String] version (nil) The version to run on.
      #   Not providing an option will run latest available.
      def initialize(opts={})
        opts = DEFAULT_OPTS.merge(opts)
        @caps = Selenium::WebDriver::Remote::Capabilities.new(opts)
      end
    end
  end
end
