require 'rspec/retry'
require_relative 'formatters/screenshot_formatter'
require_relative 'configuration/configuration'
require_relative 'configuration/driver'

Smoca::Configuration.initialize
Smoca::Configuration::Driver.initialize

RSpec.configure do |config|
  Capybara.run_server = false
  Capybara.default_driver = :selenium
  Capybara.javascript_driver = :selenium
  Capybara.server_port = 9887 + ENV['TEST_ENV_NUMBER'].to_i # Change ports of paralell threads

  # Color
  config.color = true
  config.tty = true

  config.before(:all) do
    page.driver.browser.manage.timeouts.page_load      = 45
    page.driver.browser.manage.timeouts.script_timeout = 45
  end

  #############################
  # RSpec-Retry Configuration #
  #############################
  config.verbose_retry = true # show retry status in spec process
  config.display_try_failure_messages = true # displays the failure message upon retry
  config.default_retry_count = ENV['RETRY_COUNT'] || 1

  ######################################
  # Capybara Failure Screenshot Config #
  ######################################
  date = Date.today.to_s.gsub('-', '_') # i.e., 2017_07_28 - subs the hyphens for underscores
  Capybara.save_path = "./resources/output/failures/#{date}/" # Output failure screenshots to the following path
  Capybara::Screenshot.prune_strategy = :keep_last_run # Auto delete upon new run
  Capybara::Screenshot::RSpec.add_link_to_screenshot_for_failed_examples = false

  # Only auto save if user supplies SCREENSHOTS=true
  Capybara::Screenshot.autosave_on_failure = !!(ENV['SCREENSHOTS'] == 'true')

  ###########################
  # Formatter Configuration #
  ###########################
  config.add_formatter(RSpec::Core::Formatters::DocumentationFormatter)
  config.add_formatter(ScreenshotFormatter) if ENV['SCREENSHOTS'] == 'true'
end
