# smoca_common
Common Page Objects and Utilities that are reused across multiple repositories.

An example of this may be Login Methods, in which is a core feature of the website.

## Dependencies
This must be used with the [Smoca gem](https://git-aws.internal.justin.tv/qe/smoca-core) installed.

## Using Smoca_Common
In your Gemfile:
```
source 'https://gem.internal.justin.tv' do
  gem 'smoca-core'
end
```

In your file, require the object you're looking for. Example:

```require 'smoca_common/pages/video_player/player_page'```

## Updating Code
1) Bump the version number in smoca_common.gemspec
2) Open a PR
3) Merge to Master when approved
4) Update Gem Server (details below)
5) Publish a Release on Github

### Updating Gem Server
Install Gem InABox

```
gem install geminabox
```

Build the Gem

```
gem build smoca_common.gemspec
```

Push to Gem Server (replacing the gem version and credentials as required)

```
curl -u<username>:<encrypted password> https://gem.internal.justin.tv/api/v1/api_key.yaml > ~/.gem/credentials ; chmod 600 ~/.gem/credentials 
gem push smoca_common-0.1.0.gem --host https://gem.internal.justin.tv
```

More detail:
https://git-aws.internal.justin.tv/dta/docs/blob/master/artifactory/using-artifactory.md#manual-upload
