# VodMetadataApi provides metadata related to vod.
# Note: Some key-value pairs can be null. If they are, the data attribute
# will be set to nil otherwise the value will be used.
class ChannelMetadataApi
  class << self
    attr_reader :broadcaster_logo

    # Calls twitch api on given channel.
    # @param channel [String] Channel specified to video player
    # @return response [Json] Video Player metadata
    def get_channel_metadata(channel)
      api_base_url = "https://api.twitch.tv/kraken/channels/"
      endpoint = (api_base_url + channel)
      response = HTTParty.get(endpoint,
                              headers: {'Accept' => 'application/vnd.twitchtv.v3+json',
                                        'Client-ID' => '7j65feoxl6nd7q7c5jt7uu61j60eqhp'})

      if response.code == 200
        @response = response
      else
        raise Exception.new("API request error.\n\tEndpoint: PUT #{endpoint}\n\tResponse Code: #{response.code}")
      end

      set_broadcaster_logo
    end

    private def set_broadcaster_logo
      @broadcaster_logo = @response['logo']
    end
  end
end
