# VodMetadataApi provides metadata related to vod.
# Note: Some key-value pairs can be null. If they are, the data attribute
# will be set to nil otherwise the value will be used.
class VodMetadataApi
  class << self
    attr_reader :broadcaster_name, :broadcaster_display_name, :broadcaster_title,
                :broadcaster_game
    # Calls twitch api on given vod.
    # @param vod [String] Vod specified to video player
    # @return response [Json] Video Player metadata
    def get_vod_metatdata(vod)
      api_base_url = "https://api.twitch.tv/kraken/videos/"
      endpoint = (api_base_url + vod)
      response = HTTParty.get(endpoint,
                              headers: {'Accept' => 'application/vnd.twitchtv.v3+json',
                                        'Client-ID' => '7j65feoxl6nd7q7c5jt7uu61j60eqhp'})

      if response.code == 200
        @response = response
      else
        raise Exception.new("API request error.\n\tEndpoint: PUT #{endpoint}\n\tResponse Code: #{response.code}")
      end

      set_broadcaster_name
      set_broadcaster_display_name
      set_broadcaster_title
      set_broadcaster_game
    end

    private def set_broadcaster_name
      @broadcaster_name = @response['channel']['name']
    end

    private def set_broadcaster_display_name
      @broadcaster_display_name = @response['channel']['display_name']
    end

    private def set_broadcaster_title
      @broadcaster_title = @response['title']
    end

    private def set_broadcaster_game
      @broadcaster_game = @response['game']
    end
  end
end
