require 'aws-sdk-s3'

class S3Config
  class << self

    # @return [String] The AWS Username to use
    def username
      return ENV['AWS_SCREENSHOT_USERNAME']
    end

    # @return [String] The AWS Access Key to use
    def access_key
      return ENV['AWS_SCREENSHOT_ACCESS_KEY']
    end

    # @return [String] The AWS S3 Bucket to place uploads into
    def bucket_name
      return 'smoca-screenshots'
    end

    def bucket
      return client.bucket(bucket_name)
    end

    # @return [Aws::S3::Resource]
    def client
      @client ||= Aws::S3::Resource.new(
        credentials: Aws::Credentials.new(username, access_key),
        region: 'us-west-2'
      )
    end

    # Uploads a file to the S3 Bucket
    # @param path_to_data [String] The path to the file to upload
    # @return [String] The URL where the data can be accessed
    def upload_file(path_to_data)
      return nil unless File.exist?(path_to_data)
      return nil unless authenticated?

      object = bucket.object(path_to_data)
      object.upload_file(path_to_data)
      return object.public_url
    end

    # @return [Boolean] Whether the username and access key were provided
    def authenticated?
      return !!username && !!access_key
    end

  end
end
