# Smoca Screenshots
This repository contains a service that runs Nginx on an EC2 Instance as a proxy for Amazon S3.

Why? Putting Nginx in front of S3 allows us to serve non-public images within the Twitch Network.
While one can attach a policy to the S3 bucket to allow the Twitch Network, VPN IPs are not recognized for aws:SourceIP,
meaning no one on VPN will be able to see the images.
This is the solution to that problem.

### Infrastructure
Creates an S3 Bucket and an EC2 Instance to run the proxy.

Defines an S3 Policy to
1) Allow access from the Twitch Network
2) Allow access from the EC2 Instance Proxy

Nginx Runs from within a Docker Container, as defined in Dockerfile.

When this service spins up, it will run the [twitch_qe_smoca_screenshots puppet configuration](https://git-aws.internal.justin.tv/systems/puppet/tree/master/modules/twitch_qe_smoca_screenshots/manifests/init.pp).

### Updating the Docker Container
The docker container is [hosted in Artifactory](https://packages.internal.justin.tv/artifactory/webapp/#/artifacts/browse/tree/General/docker/quality-engineering/smoca_s3_proxy/latest).

To update the docker container:
1) Build the new image. `docker build -t artdocker.internal.justin.tv/quality-engineering/smoca_s3_proxy:latest`
2) Push it. `docker push artdocker.internal.justin.tv/quality-engineering/smoca_s3_proxy:latest`

You will then need to re-run puppet on the machine to get the latest docker container.

`sudo puppet agent --test`

More details here:
https://wiki.twitch.com/display/ENG/Artifactory
