variable "cluster" {
  default = "smoca-screenshots-nginx"
}

variable "environment" {
  default = "production"
}

variable "owner" {
  default = "reichsta"
}

data "terraform_remote_state" "parent_account_vpc" {
  backend = "s3"
  config {
    profile = "twitch-cape-qe-aws"
    bucket = "tf-state-qe"
    key    = "tfstate/qe/terraform/vpc"
    region = "us-west-2"
  }
}

resource "aws_instance" "screenshot-nginx" {
  ami = "ami-48e2ac30"
  instance_type = "t2.micro"

  # Security/Subnet Groups for internal access only
  vpc_security_group_ids = ["${data.terraform_remote_state.parent_account_vpc.twitch_subnets_sg}"]
  subnet_id = "${data.terraform_remote_state.parent_account_vpc.private_a}"

  user_data = <<END_OF_STRING
#cloud-config
preserve_hostname: true
bootcmd:
 - cloud-init-per instance my_set_hostname sh -xc "echo "${var.cluster}-$INSTANCE_ID" | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
 - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).dev.us-west2.justin.tv $(cat /etc/hostname) >> /etc/hosts"
runcmd:
 - echo "twitch_environment=${var.environment}" > /etc/facter/facts.d/twitch_environment.txt
 - echo "twitch_role=${var.cluster}" > /etc/facter/facts.d/twitch_role.txt
 - echo "twitch_team=${var.owner}" > /etc/facter/facts.d/twitch_team.txt
 - echo "cluster=${var.cluster}" > /etc/facter/facts.d/cluster.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "disable_anycast=true" > /etc/facter/facts.d/disable_anycast.txt
 - puppet agent --test --server=puppet.internal.justin.tv
END_OF_STRING

  tags {
    Name = "${var.cluster}"
    Owner = "${var.owner}"
  }
}
