provider "aws" {
  alias   = "twitch-aws"
  region  = "us-west-2"
  profile = "twitch-aws"
}

variable r53_zone {
  default = "ZRG00SM48517Z"
}

resource "aws_route53_record" "smoca-screenshot" {
  provider = "aws.twitch-aws"
  zone_id = "${var.r53_zone}"
  name    = "qe-smoca-screenshots"
  type    = "A"
  ttl     = "300"
  records = ["${aws_instance.screenshot-nginx.private_ip}"]
}

output "fqdn" {
  value = "${aws_route53_record.smoca-screenshot.fqdn}"
}
