terraform {
  backend "s3" {
    # This bucket must be created manually before this plan will run!
    bucket = "twitch-browsergrid-dev"
    key    = "tfstate/account_template/us-west-2/terraform.tfstate"

    # this is where the bucket that contains the state file lives.
    region  = "us-west-2"
    profile = "twitch-browsergrid-dev"
  }
}

provider "aws" {
  alias  = "us-west-2"
  region = "us-west-2"
  profile = "twitch-browsergrid-dev"
}

module "us-west-2" {
  source            = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/account_template.git?ref=v3.1.0"
  vpc_cidr          = "10.207.112.0/22"
  name              = "twitch-browsergrid-dev"
  owner             = "twitch-browser-grid-dev+dev@amazon.com"
  systems_peer      = "nonprod"

  # you can add any additional tags you would like propagated here.
  tags = "${map("Environment","twitch-browsergrid-dev")}"

  # _if_ you are using directconnects you will need to set this to true
  enable_vgw = "false"
  azset = ["a", "b", "c"]

  providers {
    aws = "aws.us-west-2"
  }
}

output "us_west_2_private_subnets" {
  value = "${module.us-west-2.private_subnets}"
}

output "us_west_2_public_subnets" {
  value = "${module.us-west-2.public_subnets}"
}

output "us_west_2_twitch_subnets_sg_id" {
  value = "${module.us-west-2.twitch_subnets_sg_id}"
}

output "us_west_2_vpc_id" {
  value = "${module.us-west-2.vpc_id}"
}

output "us_west_2_azset" {
  value = "${module.us-west-2.azset}"
}
