#!/bin/bash
git clone https://git-aws.internal.justin.tv/security/AWS-Cloudtrail-Security-Configs   
cd AWS-Cloudtrail-Security-Configs 
export ACCOUNTID=$(aws sts get-caller-identity --output text --query 'Account')  
export REGION=$(aws configure get region)

if [ -z $ACCOUNTID ]; then echo; echo; read -n1 -r -p "No Account ID Identified.  Do not continue. Press Ctrl + C now." key;read -n1 -r -p "No Account ID Identified.  Do not continue. Press Ctrl + C now." key; echo ; echo; fi  
if [ -z $REGION ]; then echo; echo; read -n1 -r -p "No REGION Identified.  Do not continue. Press Ctrl + C now." key;read -n1 -r -p "No REGION Identified.  Do not continue. Press Ctrl + C now." key; echo ; echo; fi  

aws cloudtrail create-subscription --name cloudtrail-events-$ACCOUNTID --s3-new-bucket cloudtrail-events-$ACCOUNTID --include-global-service-events true
aws cloudtrail update-trail --name cloudtrail-events-$ACCOUNTID --is-multi-region-trail 
aws iam create-policy --policy-name Read_Only_CloudTrail_Policy --policy-document file://policy.json --description "Enables access to Cloudtrail logs"   
aws iam create-role --assume-role-policy-document file://role.json --role-name twitch-security-audit-limited   
aws iam attach-role-policy --role-name "twitch-security-audit-limited" --policy-arn "arn:aws:iam::$ACCOUNTID:policy/Read_Only_CloudTrail_Policy"  
aws iam create-policy --policy-name lambda_cloudtrail_alert_policy --policy-document file://lambda_cloudtrail_alert_policy.json --description "Enables StartLogging and SNS Notification for Lambda"
aws iam create-role --assume-role-policy-document file://role_lambda_execute_cloudtrail.json --role-name lambda_execute_cloudtrail_role
aws iam attach-role-policy --role-name lambda_execute_cloudtrail_role --policy-arn "arn:aws:iam::$ACCOUNTID:policy/lambda_cloudtrail_alert_policy"
sleep 10 #need this time to prepare role for lambda
aws lambda create-function --function-name lambda_cloudtrail_monitor --runtime python2.7 --role "arn:aws:iam::$ACCOUNTID:role/lambda_execute_cloudtrail_role" --handler lambda_cloudtrail_alert.lambda_handler --zip-file fileb://lambda.zip
aws events put-rule --name cloudwatch-event-guard --event-pattern "{\"detail\":{\"eventName\":[\"StopLogging\",\"DeleteTrail\",\"UpdateTrail\"],\"eventSource\":[\"cloudtrail.amazonaws.com\"]},\"detail-type\":[\"AWS API Call via CloudTrail\"],\"source\":[\"aws.cloudtrail\"]}"
aws events put-targets --rule cloudwatch-event-guard --targets "Id"="1","Arn"="arn:aws:lambda:$REGION:$ACCOUNTID:function:lambda_cloudtrail_monitor"
aws lambda add-permission --function-name lambda_cloudtrail_monitor --statement-id lambda_cloudtrail_monitor-$ACCOUNTID-2 --action "lambda:InvokeFunction" --principal events.amazonaws.com --source-arn "arn:aws:events:$REGION:$ACCOUNTID:rule/cloudwatch-event-guard"
aws iam get-role --role-name twitch-security-audit-limited 
