# IAM User for Grafana
resource "aws_iam_user" "grafana" {
  name = "grafana"
}

# Define a CloudWatch ReadOnly Role for Grafana to use
# Has ec2:DescribeInstances to allow for Queried Templating of AWS Instances
resource "aws_iam_group_policy" "cloudwatch_read_only" {
  name = "cloudwatch_read_only"
  group = "${aws_iam_group.metrics.id}"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "Stmt1495160498543",
      "Action": [
        "cloudwatch:DescribeAlarmHistory",
        "cloudwatch:DescribeAlarms",
        "cloudwatch:DescribeAlarmsForMetric",
        "cloudwatch:GetMetricData",
        "cloudwatch:GetMetricStatistics",
        "cloudwatch:ListMetrics",
        "ec2:DescribeInstances"
      ],
      "Effect": "Allow",
      "Resource": "*"
    }
  ]
}
EOF
}
