variable "region" {
  default = "us-west-2"
}

variable "account_name" {
  default = "twitch-cape-qe-aws"
}

module "aws_account_vpc" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/systems/terraform.git//modules/account_template/region/us-west-2?ref=bd20d8a46dff6bac58ec951e6d9cea17213bcf4b"
  region = "${var.region}"
  account_name = "${var.account_name}"
  vpc_cidr = "10.201.120.0/22"
  account_id = "425992774280"
  owner = "twitch-cape-qe@amazon.com"
  service = "${var.account_name}"
  environment = "prod"
  credential_profile="default"
  public_subnet_shift = 4
  private_subnet_shift = 2
  public_subnet_offset = 12
}

# Installs a Network Admin Role
module "network_admin_role" {
  source  = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/network-admin-role?ref=v1.0.1"
  region  = "${var.region}"
  account = "${var.account_name}"
}

output "twitch_subnets_sg" {
  value = "${module.aws_account_vpc.sg_id}"
}

output "vpc_id" {
  value = "${module.aws_account_vpc.vpc_id}"
}

output "public_a" {
  value ="${module.aws_account_vpc.public_a}"
}

output "public_b" {
  value ="${module.aws_account_vpc.public_b}"
}

output "public_c" {
  value ="${module.aws_account_vpc.public_c}"
}

output "private_a" {
  value ="${module.aws_account_vpc.private_a}"
}

output "private_b" {
  value ="${module.aws_account_vpc.private_b}"
}

output "private_c" {
  value ="${module.aws_account_vpc.private_c}"
}
