# VPC Endpoint Service Module

This module is a Python 3.x version based off this blog post:
https://aws.amazon.com/blogs/networking-and-content-delivery/using-static-ip-addresses-for-application-load-balancers/

Code was provided by Fulton:
https://code.amazon.com/packages/FultonAlbBehindNlbLambdaPython/blobs/mainline/--/handler/lambda.py

## Deploying Changes
Run `./build.sh` to create the zip file. Terraform then uses this zipped file for the lambda code.

Commit the contents, including the .zip file, to git.

## Example Usage
```
module "vpc_endpoint" {
  source                = "git::git+ssh://git@git.xarth.tv/qe/terraform//modules/vpc_endpoint_service"
  environment_name      = "${aws_elastic_beanstalk_environment.heimdall.name}"
  loadbalancer_dns_name = "${aws_elastic_beanstalk_environment.heimdall.endpoint_url}"
  vpc_id                = "vpc-25d89842"
  subnets               = ["subnet-cf9a03a8"]
}
```
