freeStyleJob('qe-test-repo') {
  using 'TEMPLATE-autobuild'

  wrappers {
    environmentVariables {
      env('GIT_BRANCH', '${GIT_BRANCH}')
      env('GIT_COMMIT', '${GIT_COMMIT}')
      env('GIT_URL', '${GIT_URL}')
    }
  }

  scm {
    git {
      remote {
        github 'qe/test-repo', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    preBuildCleanup()
    timestamps()
    environmentVariables {
      env('ENVIRONMENT', 'development')
    }
  }

  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v'
  }

  publishers {
    reportQuality('qe/test-repo', '.manta', '*.txt')
  }
}
