#!/bin/bash

OUT="$(pwd)/output"

mkdir -p ${OUT}
echo 'building ...'
go build $(glide novendor)
echo 'Running New Checks ...'
go get -u gopkg.in/alecthomas/gometalinter.v2
gometalinter --install
gometalinter --config='gometalinterConfig.json' ./...
echo 'testing ...'
go test -race $(glide novendor)
CMD_PKGS=$(go list -f '{{if eq .Name "main"}}{{.ImportPath}}{{end}}' -- $(glide novendor))
for cmd in $CMD_PKGS; do
  echo "installing $cmd ..."
  GOBIN="${OUT}" go install "${cmd}"
done
