#!/bin/bash

set -e

ACCOUNT=$1

case "$ACCOUNT" in
        twitch-cape-qe-aws)
            ENVIRONMENTS=(production canary staging)
            ;;
        *)
            echo "Unknown account \"$ACCOUNT\", exiting"
            exit 1
esac

cd ./terraform/${ACCOUNT}

for ENVIRONMENT in "${ENVIRONMENTS[@]}"
do
    ROLE=`terraform output ${ENVIRONMENT}-iam_role_arn`

    tcs sandstorm role-flags \
        --owner team-qa \
        --name qa-${ENVIRONMENT}-test-tcs-go-repo \
        --secret_key "qa/test-tcs-go-repo/${ENVIRONMENT}/*" \
        --allowed_arn "${ROLE}" \
        --output ./sandstorm.d/${ACCOUNT}_${ENVIRONMENT}.json

done
