package xray

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestTraceID(t *testing.T) {
	ctx, seg := newSegment(context.Background(), "name")
	traceID := TraceID(ctx)
	assert.Equal(t, seg.TraceID, traceID)
}

func TestEmptyTraceID(t *testing.T) {
	traceID := TraceID(context.Background())
	assert.Empty(t, traceID)
}
