package ecs

import (
	"log"
	"os"

	"code.justin.tv/foundation/xray/internal/plugins"
)

func init() {
	if plugins.InstancePluginMetadata != nil && plugins.InstancePluginMetadata.ECSContainerName == "" {
		addPluginMetadata(plugins.InstancePluginMetadata)
	}
}

func addPluginMetadata(pluginmd *plugins.PluginMetadata) {
	hostname, err := os.Hostname()

	if err != nil {
		log.Printf("Unable to retrieve hostname from OS. %v", err)
	}

	pluginmd.ECSContainerName = hostname
}
