// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/release/trace/api/report_v1/httpbody.proto

package report_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Message that represents an arbitrary HTTP body. It should only be used for
// payload formats that can't be represented as JSON, such as raw binary or
// an HTML page.
//
//
// This message can be used both in streaming and non-streaming API methods in
// the request as well as the response.
//
// It can be used as a top-level request field, which is convenient if one
// wants to extract parameters from either the URL or HTTP template into the
// request fields and also want access to the raw HTTP body.
//
// Example:
//
//     message GetResourceRequest {
//       // A unique request id.
//       string request_id = 1;
//
//       // The raw HTTP body is bound to this field.
//       google.api.HttpBody http_body = 2;
//     }
//
//     service ResourceService {
//       rpc GetResource(GetResourceRequest) returns (google.api.HttpBody);
//       rpc UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty);
//     }
//
// Example with streaming methods:
//
//     service CaldavService {
//       rpc GetCalendar(stream google.api.HttpBody)
//         returns (stream google.api.HttpBody);
//       rpc UpdateCalendar(stream google.api.HttpBody)
//         returns (stream google.api.HttpBody);
//     }
//
// Use of this type only changes how the request and response bodies are
// handled, all other features will continue to work unchanged.
type HttpBody struct {
	// The HTTP Content-Type string representing the content type of the body.
	ContentType string `protobuf:"bytes,1,opt,name=content_type,json=contentType" json:"content_type,omitempty"`
	// HTTP body binary data.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *HttpBody) Reset()                    { *m = HttpBody{} }
func (m *HttpBody) String() string            { return proto.CompactTextString(m) }
func (*HttpBody) ProtoMessage()               {}
func (*HttpBody) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *HttpBody) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *HttpBody) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterType((*HttpBody)(nil), "code.justin.tv.release.trace.api.report.v1.HttpBody")
}

func init() {
	proto.RegisterFile("code.justin.tv/release/trace/api/report_v1/httpbody.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 170 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0xce, 0x31, 0xcb, 0xc2, 0x30,
	0x10, 0xc6, 0x71, 0xfa, 0xf2, 0x22, 0x36, 0xed, 0x94, 0xa9, 0x63, 0x75, 0x2a, 0x0e, 0x17, 0x8a,
	0x93, 0xa3, 0x9d, 0x9c, 0x8b, 0x93, 0x4b, 0x49, 0x9b, 0x03, 0x2b, 0xd2, 0x3b, 0xd2, 0xb3, 0x90,
	0x6f, 0x2f, 0xc4, 0x22, 0xb8, 0x3d, 0x3c, 0xf0, 0x83, 0xbf, 0x3a, 0x0d, 0xe4, 0x10, 0x1e, 0xaf,
	0x59, 0xc6, 0x09, 0x64, 0x31, 0x1e, 0x9f, 0x68, 0x67, 0x34, 0xe2, 0xed, 0x80, 0xc6, 0xf2, 0x68,
	0x3c, 0x32, 0x79, 0xe9, 0x96, 0xda, 0xdc, 0x45, 0xb8, 0x27, 0x17, 0x80, 0x3d, 0x09, 0xe9, 0xc3,
	0x2f, 0x85, 0x95, 0x42, 0xa4, 0x60, 0x79, 0x84, 0x0f, 0x85, 0xa5, 0xde, 0x9f, 0xd5, 0xf6, 0x22,
	0xc2, 0x0d, 0xb9, 0xa0, 0x77, 0x2a, 0x1f, 0x68, 0x12, 0x9c, 0xa4, 0x93, 0xc0, 0x58, 0x24, 0x65,
	0x52, 0xa5, 0x6d, 0xb6, 0x7e, 0xd7, 0xc0, 0xa8, 0xb5, 0xfa, 0x77, 0x56, 0x6c, 0xf1, 0x57, 0x26,
	0x55, 0xde, 0xc6, 0xdd, 0x64, 0xb7, 0xf4, 0x9b, 0xd2, 0x6f, 0x62, 0xc2, 0xf1, 0x1d, 0x00, 0x00,
	0xff, 0xff, 0x96, 0x22, 0x6d, 0x54, 0xbf, 0x00, 0x00, 0x00,
}
