package main

import (
	"context"
	"flag"
	"io/ioutil"
	"net/http"
	"net/http/httptest"
	"net/url"
	"os"
	"os/exec"
	"testing"
	"time"
)

var callDoMain = flag.Bool("act-as-command", false, "Act as command-line tool, for use in sub-tests")

func TestMain(m *testing.M) {
	flag.Parse()
	if *callDoMain {
		doMain()
		os.Exit(0)
	}
	os.Exit(m.Run())
}

func TestReportCommand(t *testing.T) {
	ctx, cancel := context.WithCancel(context.Background())
	srv := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		ctx, cancel := context.WithTimeout(ctx, 10*time.Second)
		defer cancel()
		<-ctx.Done()
	}))
	defer srv.Close()
	defer cancel()

	u, err := url.Parse(srv.URL)
	if err != nil {
		t.Fatalf("url.Parse; err = %q", err)
	}

	for i := 0; i < 30; i++ {
		t.Run("", func(t *testing.T) {
			t.Parallel()

			dir, err := ioutil.TempDir("", "txreport")
			if err != nil {
				t.Fatalf("ioutil.TempDir; err = %q", err)
			}
			defer os.RemoveAll(dir)

			cmd := exec.Command(os.Args[0], "-act-as-command=true",
				"-api=true", "-apihost", u.Host,
				"-flush=1ms", "-outdir", dir)
			out, err := cmd.CombinedOutput()
			if err != nil {
				t.Errorf("command err=%q", err)
				t.Errorf("output:\n%s", out)
				t.FailNow()
			}
		})
	}
}
