#!/usr/bin/env bash
set -e -o pipefail -u

for dir in *; do
	if [[ ! -d "${dir}" ]]; then
		continue
	fi
	pushd "${dir}" >/dev/null

	coderoot="$(go list -f '{{.Root}}' .)/src"

	protoc \
		--twirp_out="${coderoot}" \
		--proto_path="${coderoot}" \
		--proto_path="${coderoot}"/github.com/google/protobuf/src \
		--proto_path="${coderoot}"/github.com/googleapis/googleapis \
		"${PWD}"/*.proto

	popd >/dev/null
done
exit 0
