// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/release/trace/internal/ext/guardian_v1/guardian.proto

/*
Package guardian_v1 is a generated protocol buffer package.

It is generated from these files:
	code.justin.tv/release/trace/internal/ext/guardian_v1/guardian.proto

It has these top-level messages:
	User
	Group
	Client
	JsonApi
	Error
	ListUsersRequest
	ListUsersResponse
	GetUserRequest
	GetUserResponse
	ListGroupsRequest
	ListGroupsResponse
	GetGroupRequest
	GetGroupResponse
	ListClientsRequest
	ListClientsResponse
	GetClientRequest
	GetClientResponse
	CreateClientRequest
	CreateClientResponse
	UpdateClientRequest
	UpdateClientResponse
	DeleteClientRequest
*/
package guardian_v1

import (
	"code.justin.tv/common/chitin/grpctrace"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"

	math "math"

	_ "google.golang.org/genproto/googleapis/api/annotations"

	google_protobuf1 "github.com/golang/protobuf/ptypes/empty"

	context "golang.org/x/net/context"

	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An LDAP user as exposed for read-only access by the GuardiaN API.
type User struct {
	Id         string           `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Type       string           `protobuf:"bytes,2,opt,name=type" json:"type,omitempty"`
	Attributes *User_Attributes `protobuf:"bytes,3,opt,name=attributes" json:"attributes,omitempty"`
}

func (m *User) Reset()                    { *m = User{} }
func (m *User) String() string            { return proto.CompactTextString(m) }
func (*User) ProtoMessage()               {}
func (*User) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *User) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *User) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *User) GetAttributes() *User_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

type User_Attributes struct {
	Uid       string   `protobuf:"bytes,1,opt,name=uid" json:"uid,omitempty"`
	UidNumber int32    `protobuf:"varint,2,opt,name=uid_number,json=uidNumber" json:"uid_number,omitempty"`
	Email     string   `protobuf:"bytes,3,opt,name=email" json:"email,omitempty"`
	Cn        string   `protobuf:"bytes,4,opt,name=cn" json:"cn,omitempty"`
	GidNumber int32    `protobuf:"varint,5,opt,name=gid_number,json=gidNumber" json:"gid_number,omitempty"`
	HomeDir   string   `protobuf:"bytes,6,opt,name=home_dir,json=homeDir" json:"home_dir,omitempty"`
	Groups    []string `protobuf:"bytes,7,rep,name=groups" json:"groups,omitempty"`
}

func (m *User_Attributes) Reset()                    { *m = User_Attributes{} }
func (m *User_Attributes) String() string            { return proto.CompactTextString(m) }
func (*User_Attributes) ProtoMessage()               {}
func (*User_Attributes) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

func (m *User_Attributes) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *User_Attributes) GetUidNumber() int32 {
	if m != nil {
		return m.UidNumber
	}
	return 0
}

func (m *User_Attributes) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *User_Attributes) GetCn() string {
	if m != nil {
		return m.Cn
	}
	return ""
}

func (m *User_Attributes) GetGidNumber() int32 {
	if m != nil {
		return m.GidNumber
	}
	return 0
}

func (m *User_Attributes) GetHomeDir() string {
	if m != nil {
		return m.HomeDir
	}
	return ""
}

func (m *User_Attributes) GetGroups() []string {
	if m != nil {
		return m.Groups
	}
	return nil
}

// An LDAP group as exposed for read-only access by the GuardiaN API.
type Group struct {
	Id         string            `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Type       string            `protobuf:"bytes,2,opt,name=type" json:"type,omitempty"`
	Attributes *Group_Attributes `protobuf:"bytes,3,opt,name=attributes" json:"attributes,omitempty"`
}

func (m *Group) Reset()                    { *m = Group{} }
func (m *Group) String() string            { return proto.CompactTextString(m) }
func (*Group) ProtoMessage()               {}
func (*Group) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Group) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Group) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Group) GetAttributes() *Group_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

type Group_Attributes struct {
	Gid         int32    `protobuf:"varint,1,opt,name=gid" json:"gid,omitempty"`
	Cn          string   `protobuf:"bytes,2,opt,name=cn" json:"cn,omitempty"`
	Description string   `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	Members     []string `protobuf:"bytes,4,rep,name=members" json:"members,omitempty"`
}

func (m *Group_Attributes) Reset()                    { *m = Group_Attributes{} }
func (m *Group_Attributes) String() string            { return proto.CompactTextString(m) }
func (*Group_Attributes) ProtoMessage()               {}
func (*Group_Attributes) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1, 0} }

func (m *Group_Attributes) GetGid() int32 {
	if m != nil {
		return m.Gid
	}
	return 0
}

func (m *Group_Attributes) GetCn() string {
	if m != nil {
		return m.Cn
	}
	return ""
}

func (m *Group_Attributes) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Group_Attributes) GetMembers() []string {
	if m != nil {
		return m.Members
	}
	return nil
}

// A Twitch-internal OAuth2 client.
type Client struct {
	Id         string             `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Type       string             `protobuf:"bytes,2,opt,name=type" json:"type,omitempty"`
	Attributes *Client_Attributes `protobuf:"bytes,3,opt,name=attributes" json:"attributes,omitempty"`
}

func (m *Client) Reset()                    { *m = Client{} }
func (m *Client) String() string            { return proto.CompactTextString(m) }
func (*Client) ProtoMessage()               {}
func (*Client) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Client) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Client) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Client) GetAttributes() *Client_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

type Client_Attributes struct {
	Id            string   `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Name          string   `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	Description   string   `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	Version       string   `protobuf:"bytes,4,opt,name=version" json:"version,omitempty"`
	RedirectUri   string   `protobuf:"bytes,5,opt,name=redirect_uri" json:"redirect_uri,omitempty"`
	Homepage      string   `protobuf:"bytes,6,opt,name=homepage" json:"homepage,omitempty"`
	SecretHash    string   `protobuf:"bytes,7,opt,name=secret_hash" json:"secret_hash,omitempty"`
	HashAlgorithm string   `protobuf:"bytes,8,opt,name=hash_algorithm" json:"hash_algorithm,omitempty"`
	Scopes        []string `protobuf:"bytes,9,rep,name=scopes" json:"scopes,omitempty"`
	Groups        []string `protobuf:"bytes,10,rep,name=groups" json:"groups,omitempty"`
}

func (m *Client_Attributes) Reset()                    { *m = Client_Attributes{} }
func (m *Client_Attributes) String() string            { return proto.CompactTextString(m) }
func (*Client_Attributes) ProtoMessage()               {}
func (*Client_Attributes) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

func (m *Client_Attributes) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Client_Attributes) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Client_Attributes) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Client_Attributes) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Client_Attributes) GetRedirectUri() string {
	if m != nil {
		return m.RedirectUri
	}
	return ""
}

func (m *Client_Attributes) GetHomepage() string {
	if m != nil {
		return m.Homepage
	}
	return ""
}

func (m *Client_Attributes) GetSecretHash() string {
	if m != nil {
		return m.SecretHash
	}
	return ""
}

func (m *Client_Attributes) GetHashAlgorithm() string {
	if m != nil {
		return m.HashAlgorithm
	}
	return ""
}

func (m *Client_Attributes) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *Client_Attributes) GetGroups() []string {
	if m != nil {
		return m.Groups
	}
	return nil
}

type JsonApi struct {
	Version string `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
}

func (m *JsonApi) Reset()                    { *m = JsonApi{} }
func (m *JsonApi) String() string            { return proto.CompactTextString(m) }
func (*JsonApi) ProtoMessage()               {}
func (*JsonApi) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *JsonApi) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type Error struct {
	Title  string        `protobuf:"bytes,1,opt,name=title" json:"title,omitempty"`
	Detail string        `protobuf:"bytes,2,opt,name=detail" json:"detail,omitempty"`
	Status string        `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	Source *Error_Source `protobuf:"bytes,4,opt,name=source" json:"source,omitempty"`
}

func (m *Error) Reset()                    { *m = Error{} }
func (m *Error) String() string            { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()               {}
func (*Error) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Error) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Error) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

func (m *Error) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Error) GetSource() *Error_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

type Error_Source struct {
	Pointer string `protobuf:"bytes,1,opt,name=pointer" json:"pointer,omitempty"`
}

func (m *Error_Source) Reset()                    { *m = Error_Source{} }
func (m *Error_Source) String() string            { return proto.CompactTextString(m) }
func (*Error_Source) ProtoMessage()               {}
func (*Error_Source) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4, 0} }

func (m *Error_Source) GetPointer() string {
	if m != nil {
		return m.Pointer
	}
	return ""
}

type ListUsersRequest struct {
}

func (m *ListUsersRequest) Reset()                    { *m = ListUsersRequest{} }
func (m *ListUsersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListUsersRequest) ProtoMessage()               {}
func (*ListUsersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type ListUsersResponse struct {
	Users   []*User  `protobuf:"bytes,1,rep,name=users,json=data" json:"users,omitempty"`
	JsonApi *JsonApi `protobuf:"bytes,2,opt,name=json_api,json=jsonapi" json:"json_api,omitempty"`
	Errors  []*Error `protobuf:"bytes,3,rep,name=errors" json:"errors,omitempty"`
}

func (m *ListUsersResponse) Reset()                    { *m = ListUsersResponse{} }
func (m *ListUsersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListUsersResponse) ProtoMessage()               {}
func (*ListUsersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ListUsersResponse) GetUsers() []*User {
	if m != nil {
		return m.Users
	}
	return nil
}

func (m *ListUsersResponse) GetJsonApi() *JsonApi {
	if m != nil {
		return m.JsonApi
	}
	return nil
}

func (m *ListUsersResponse) GetErrors() []*Error {
	if m != nil {
		return m.Errors
	}
	return nil
}

type GetUserRequest struct {
	Uid string `protobuf:"bytes,1,opt,name=uid" json:"uid,omitempty"`
}

func (m *GetUserRequest) Reset()                    { *m = GetUserRequest{} }
func (m *GetUserRequest) String() string            { return proto.CompactTextString(m) }
func (*GetUserRequest) ProtoMessage()               {}
func (*GetUserRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetUserRequest) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

type GetUserResponse struct {
	User    *User    `protobuf:"bytes,1,opt,name=user,json=data" json:"user,omitempty"`
	JsonApi *JsonApi `protobuf:"bytes,2,opt,name=json_api,json=jsonapi" json:"json_api,omitempty"`
	Errors  []*Error `protobuf:"bytes,3,rep,name=errors" json:"errors,omitempty"`
}

func (m *GetUserResponse) Reset()                    { *m = GetUserResponse{} }
func (m *GetUserResponse) String() string            { return proto.CompactTextString(m) }
func (*GetUserResponse) ProtoMessage()               {}
func (*GetUserResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *GetUserResponse) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *GetUserResponse) GetJsonApi() *JsonApi {
	if m != nil {
		return m.JsonApi
	}
	return nil
}

func (m *GetUserResponse) GetErrors() []*Error {
	if m != nil {
		return m.Errors
	}
	return nil
}

type ListGroupsRequest struct {
}

func (m *ListGroupsRequest) Reset()                    { *m = ListGroupsRequest{} }
func (m *ListGroupsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListGroupsRequest) ProtoMessage()               {}
func (*ListGroupsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type ListGroupsResponse struct {
	Groups  []*Group `protobuf:"bytes,1,rep,name=groups,json=data" json:"groups,omitempty"`
	JsonApi *JsonApi `protobuf:"bytes,2,opt,name=json_api,json=jsonapi" json:"json_api,omitempty"`
	Errors  []*Error `protobuf:"bytes,3,rep,name=errors" json:"errors,omitempty"`
}

func (m *ListGroupsResponse) Reset()                    { *m = ListGroupsResponse{} }
func (m *ListGroupsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListGroupsResponse) ProtoMessage()               {}
func (*ListGroupsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ListGroupsResponse) GetGroups() []*Group {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *ListGroupsResponse) GetJsonApi() *JsonApi {
	if m != nil {
		return m.JsonApi
	}
	return nil
}

func (m *ListGroupsResponse) GetErrors() []*Error {
	if m != nil {
		return m.Errors
	}
	return nil
}

type GetGroupRequest struct {
	Cn string `protobuf:"bytes,1,opt,name=cn" json:"cn,omitempty"`
}

func (m *GetGroupRequest) Reset()                    { *m = GetGroupRequest{} }
func (m *GetGroupRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGroupRequest) ProtoMessage()               {}
func (*GetGroupRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *GetGroupRequest) GetCn() string {
	if m != nil {
		return m.Cn
	}
	return ""
}

type GetGroupResponse struct {
	Group   *Group   `protobuf:"bytes,1,opt,name=group,json=data" json:"group,omitempty"`
	JsonApi *JsonApi `protobuf:"bytes,2,opt,name=json_api,json=jsonapi" json:"json_api,omitempty"`
	Errors  []*Error `protobuf:"bytes,3,rep,name=errors" json:"errors,omitempty"`
}

func (m *GetGroupResponse) Reset()                    { *m = GetGroupResponse{} }
func (m *GetGroupResponse) String() string            { return proto.CompactTextString(m) }
func (*GetGroupResponse) ProtoMessage()               {}
func (*GetGroupResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GetGroupResponse) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (m *GetGroupResponse) GetJsonApi() *JsonApi {
	if m != nil {
		return m.JsonApi
	}
	return nil
}

func (m *GetGroupResponse) GetErrors() []*Error {
	if m != nil {
		return m.Errors
	}
	return nil
}

type ListClientsRequest struct {
}

func (m *ListClientsRequest) Reset()                    { *m = ListClientsRequest{} }
func (m *ListClientsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListClientsRequest) ProtoMessage()               {}
func (*ListClientsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

type ListClientsResponse struct {
	Clients []*Client `protobuf:"bytes,1,rep,name=clients,json=data" json:"clients,omitempty"`
	JsonApi *JsonApi  `protobuf:"bytes,2,opt,name=json_api,json=jsonapi" json:"json_api,omitempty"`
	Errors  []*Error  `protobuf:"bytes,3,rep,name=errors" json:"errors,omitempty"`
}

func (m *ListClientsResponse) Reset()                    { *m = ListClientsResponse{} }
func (m *ListClientsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListClientsResponse) ProtoMessage()               {}
func (*ListClientsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ListClientsResponse) GetClients() []*Client {
	if m != nil {
		return m.Clients
	}
	return nil
}

func (m *ListClientsResponse) GetJsonApi() *JsonApi {
	if m != nil {
		return m.JsonApi
	}
	return nil
}

func (m *ListClientsResponse) GetErrors() []*Error {
	if m != nil {
		return m.Errors
	}
	return nil
}

type GetClientRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *GetClientRequest) Reset()                    { *m = GetClientRequest{} }
func (m *GetClientRequest) String() string            { return proto.CompactTextString(m) }
func (*GetClientRequest) ProtoMessage()               {}
func (*GetClientRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *GetClientRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type GetClientResponse struct {
	Client  *Client  `protobuf:"bytes,1,opt,name=client,json=data" json:"client,omitempty"`
	JsonApi *JsonApi `protobuf:"bytes,2,opt,name=json_api,json=jsonapi" json:"json_api,omitempty"`
	Errors  []*Error `protobuf:"bytes,3,rep,name=errors" json:"errors,omitempty"`
}

func (m *GetClientResponse) Reset()                    { *m = GetClientResponse{} }
func (m *GetClientResponse) String() string            { return proto.CompactTextString(m) }
func (*GetClientResponse) ProtoMessage()               {}
func (*GetClientResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *GetClientResponse) GetClient() *Client {
	if m != nil {
		return m.Client
	}
	return nil
}

func (m *GetClientResponse) GetJsonApi() *JsonApi {
	if m != nil {
		return m.JsonApi
	}
	return nil
}

func (m *GetClientResponse) GetErrors() []*Error {
	if m != nil {
		return m.Errors
	}
	return nil
}

type CreateClientRequest struct {
	// Details of the client to be created.
	//
	// `client.type` must be set to `"clients"`
	Client *Client `protobuf:"bytes,1,opt,name=client,json=data" json:"client,omitempty"`
}

func (m *CreateClientRequest) Reset()                    { *m = CreateClientRequest{} }
func (m *CreateClientRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateClientRequest) ProtoMessage()               {}
func (*CreateClientRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *CreateClientRequest) GetClient() *Client {
	if m != nil {
		return m.Client
	}
	return nil
}

type CreateClientResponse struct {
	Client  *Client  `protobuf:"bytes,1,opt,name=client,json=data" json:"client,omitempty"`
	JsonApi *JsonApi `protobuf:"bytes,2,opt,name=json_api,json=jsonapi" json:"json_api,omitempty"`
	Errors  []*Error `protobuf:"bytes,3,rep,name=errors" json:"errors,omitempty"`
}

func (m *CreateClientResponse) Reset()                    { *m = CreateClientResponse{} }
func (m *CreateClientResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateClientResponse) ProtoMessage()               {}
func (*CreateClientResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *CreateClientResponse) GetClient() *Client {
	if m != nil {
		return m.Client
	}
	return nil
}

func (m *CreateClientResponse) GetJsonApi() *JsonApi {
	if m != nil {
		return m.JsonApi
	}
	return nil
}

func (m *CreateClientResponse) GetErrors() []*Error {
	if m != nil {
		return m.Errors
	}
	return nil
}

type UpdateClientRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Details of the client to be updated.
	//
	// `client.type` must be set to `"clients"`.
	//
	// `client.id` must be set.
	Client *Client `protobuf:"bytes,2,opt,name=client,json=data" json:"client,omitempty"`
}

func (m *UpdateClientRequest) Reset()                    { *m = UpdateClientRequest{} }
func (m *UpdateClientRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateClientRequest) ProtoMessage()               {}
func (*UpdateClientRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *UpdateClientRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *UpdateClientRequest) GetClient() *Client {
	if m != nil {
		return m.Client
	}
	return nil
}

type UpdateClientResponse struct {
	Client  *Client  `protobuf:"bytes,1,opt,name=client,json=data" json:"client,omitempty"`
	JsonApi *JsonApi `protobuf:"bytes,2,opt,name=json_api,json=jsonapi" json:"json_api,omitempty"`
	Errors  []*Error `protobuf:"bytes,3,rep,name=errors" json:"errors,omitempty"`
}

func (m *UpdateClientResponse) Reset()                    { *m = UpdateClientResponse{} }
func (m *UpdateClientResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateClientResponse) ProtoMessage()               {}
func (*UpdateClientResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *UpdateClientResponse) GetClient() *Client {
	if m != nil {
		return m.Client
	}
	return nil
}

func (m *UpdateClientResponse) GetJsonApi() *JsonApi {
	if m != nil {
		return m.JsonApi
	}
	return nil
}

func (m *UpdateClientResponse) GetErrors() []*Error {
	if m != nil {
		return m.Errors
	}
	return nil
}

type DeleteClientRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *DeleteClientRequest) Reset()                    { *m = DeleteClientRequest{} }
func (m *DeleteClientRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteClientRequest) ProtoMessage()               {}
func (*DeleteClientRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *DeleteClientRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func init() {
	proto.RegisterType((*User)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.User")
	proto.RegisterType((*User_Attributes)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.User.Attributes")
	proto.RegisterType((*Group)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.Group")
	proto.RegisterType((*Group_Attributes)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.Group.Attributes")
	proto.RegisterType((*Client)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.Client")
	proto.RegisterType((*Client_Attributes)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.Client.Attributes")
	proto.RegisterType((*JsonApi)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.JsonApi")
	proto.RegisterType((*Error)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.Error")
	proto.RegisterType((*Error_Source)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.Error.Source")
	proto.RegisterType((*ListUsersRequest)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.ListUsersRequest")
	proto.RegisterType((*ListUsersResponse)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.ListUsersResponse")
	proto.RegisterType((*GetUserRequest)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.GetUserRequest")
	proto.RegisterType((*GetUserResponse)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.GetUserResponse")
	proto.RegisterType((*ListGroupsRequest)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.ListGroupsRequest")
	proto.RegisterType((*ListGroupsResponse)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.ListGroupsResponse")
	proto.RegisterType((*GetGroupRequest)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.GetGroupRequest")
	proto.RegisterType((*GetGroupResponse)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.GetGroupResponse")
	proto.RegisterType((*ListClientsRequest)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.ListClientsRequest")
	proto.RegisterType((*ListClientsResponse)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.ListClientsResponse")
	proto.RegisterType((*GetClientRequest)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.GetClientRequest")
	proto.RegisterType((*GetClientResponse)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.GetClientResponse")
	proto.RegisterType((*CreateClientRequest)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.CreateClientRequest")
	proto.RegisterType((*CreateClientResponse)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.CreateClientResponse")
	proto.RegisterType((*UpdateClientRequest)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.UpdateClientRequest")
	proto.RegisterType((*UpdateClientResponse)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.UpdateClientResponse")
	proto.RegisterType((*DeleteClientRequest)(nil), "code_justin_tv.release.trace.internal.ext.guardian.v1.DeleteClientRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Guardian service

type GuardianClient interface {
	// Lists all LDAP users.
	//
	// No authentication required.
	ListUsers(ctx context.Context, in *ListUsersRequest, opts ...grpc.CallOption) (*ListUsersResponse, error)
	// Gets details of a single LDAP user, including the names (`cn`) of all
	// groups of which the user is a member.
	//
	// No authentication required.
	GetUser(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*GetUserResponse, error)
	// Lists all LDAP groups.
	//
	// No authentication required.
	ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error)
	// Gets details of a single LDAP group, including the full names (`cn`) of
	// all member users.
	//
	// No authentication required.
	GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*GetGroupResponse, error)
	// Lists all Twitch-internal OAuth2 client applications.
	//
	// Authentication is required.
	ListClients(ctx context.Context, in *ListClientsRequest, opts ...grpc.CallOption) (*ListClientsResponse, error)
	// Gets details of a single Twitch-internal OAuth2 client application.
	//
	// Authentication is required.
	GetClient(ctx context.Context, in *GetClientRequest, opts ...grpc.CallOption) (*GetClientResponse, error)
	// Creates a Twitch-internal OAuth2 client application.
	//
	// Authentication is required. Content-Type must be
	// `application/vnd.api+json`. See the request message for details on which
	// fields must be set.
	CreateClient(ctx context.Context, in *CreateClientRequest, opts ...grpc.CallOption) (*CreateClientResponse, error)
	// Updates a Twitch-internal OAuth2 client application.
	//
	// Authentication is required. Content-Type must be
	// `application/vnd.api+json`. See the request message for details on which
	// fields must be set.
	UpdateClient(ctx context.Context, in *UpdateClientRequest, opts ...grpc.CallOption) (*UpdateClientResponse, error)
	// Deletes a Twitch-internal OAuth2 client application.
	//
	// Authentication is required.
	DeleteClient(ctx context.Context, in *DeleteClientRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
}

type guardianClient struct {
	cc *grpc.ClientConn
}

func NewGuardianClient(cc *grpc.ClientConn) GuardianClient {
	return &guardianClient{cc}
}

func (c *guardianClient) ListUsers(ctx context.Context, in *ListUsersRequest, opts ...grpc.CallOption) (*ListUsersResponse, error) {
	out := new(ListUsersResponse)
	err := grpctrace.Invoke(ctx, "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/ListUsers", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guardianClient) GetUser(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*GetUserResponse, error) {
	out := new(GetUserResponse)
	err := grpctrace.Invoke(ctx, "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/GetUser", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guardianClient) ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error) {
	out := new(ListGroupsResponse)
	err := grpctrace.Invoke(ctx, "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/ListGroups", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guardianClient) GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*GetGroupResponse, error) {
	out := new(GetGroupResponse)
	err := grpctrace.Invoke(ctx, "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/GetGroup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guardianClient) ListClients(ctx context.Context, in *ListClientsRequest, opts ...grpc.CallOption) (*ListClientsResponse, error) {
	out := new(ListClientsResponse)
	err := grpctrace.Invoke(ctx, "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/ListClients", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guardianClient) GetClient(ctx context.Context, in *GetClientRequest, opts ...grpc.CallOption) (*GetClientResponse, error) {
	out := new(GetClientResponse)
	err := grpctrace.Invoke(ctx, "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/GetClient", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guardianClient) CreateClient(ctx context.Context, in *CreateClientRequest, opts ...grpc.CallOption) (*CreateClientResponse, error) {
	out := new(CreateClientResponse)
	err := grpctrace.Invoke(ctx, "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/CreateClient", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guardianClient) UpdateClient(ctx context.Context, in *UpdateClientRequest, opts ...grpc.CallOption) (*UpdateClientResponse, error) {
	out := new(UpdateClientResponse)
	err := grpctrace.Invoke(ctx, "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/UpdateClient", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guardianClient) DeleteClient(ctx context.Context, in *DeleteClientRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpctrace.Invoke(ctx, "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/DeleteClient", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Guardian service

type GuardianServer interface {
	// Lists all LDAP users.
	//
	// No authentication required.
	ListUsers(context.Context, *ListUsersRequest) (*ListUsersResponse, error)
	// Gets details of a single LDAP user, including the names (`cn`) of all
	// groups of which the user is a member.
	//
	// No authentication required.
	GetUser(context.Context, *GetUserRequest) (*GetUserResponse, error)
	// Lists all LDAP groups.
	//
	// No authentication required.
	ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error)
	// Gets details of a single LDAP group, including the full names (`cn`) of
	// all member users.
	//
	// No authentication required.
	GetGroup(context.Context, *GetGroupRequest) (*GetGroupResponse, error)
	// Lists all Twitch-internal OAuth2 client applications.
	//
	// Authentication is required.
	ListClients(context.Context, *ListClientsRequest) (*ListClientsResponse, error)
	// Gets details of a single Twitch-internal OAuth2 client application.
	//
	// Authentication is required.
	GetClient(context.Context, *GetClientRequest) (*GetClientResponse, error)
	// Creates a Twitch-internal OAuth2 client application.
	//
	// Authentication is required. Content-Type must be
	// `application/vnd.api+json`. See the request message for details on which
	// fields must be set.
	CreateClient(context.Context, *CreateClientRequest) (*CreateClientResponse, error)
	// Updates a Twitch-internal OAuth2 client application.
	//
	// Authentication is required. Content-Type must be
	// `application/vnd.api+json`. See the request message for details on which
	// fields must be set.
	UpdateClient(context.Context, *UpdateClientRequest) (*UpdateClientResponse, error)
	// Deletes a Twitch-internal OAuth2 client application.
	//
	// Authentication is required.
	DeleteClient(context.Context, *DeleteClientRequest) (*google_protobuf1.Empty, error)
}

func RegisterGuardianServer(s *grpc.Server, srv GuardianServer) {
	grpctrace.RegisterService(s, &_Guardian_serviceDesc, srv)
}

func _Guardian_ListUsers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuardianServer).ListUsers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/ListUsers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuardianServer).ListUsers(ctx, req.(*ListUsersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Guardian_GetUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuardianServer).GetUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/GetUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuardianServer).GetUser(ctx, req.(*GetUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Guardian_ListGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuardianServer).ListGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/ListGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuardianServer).ListGroups(ctx, req.(*ListGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Guardian_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuardianServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/GetGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuardianServer).GetGroup(ctx, req.(*GetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Guardian_ListClients_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClientsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuardianServer).ListClients(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/ListClients",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuardianServer).ListClients(ctx, req.(*ListClientsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Guardian_GetClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuardianServer).GetClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/GetClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuardianServer).GetClient(ctx, req.(*GetClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Guardian_CreateClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuardianServer).CreateClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/CreateClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuardianServer).CreateClient(ctx, req.(*CreateClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Guardian_UpdateClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuardianServer).UpdateClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/UpdateClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuardianServer).UpdateClient(ctx, req.(*UpdateClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Guardian_DeleteClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuardianServer).DeleteClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/DeleteClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuardianServer).DeleteClient(ctx, req.(*DeleteClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Guardian_serviceDesc = grpc.ServiceDesc{
	ServiceName: "code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian",
	HandlerType: (*GuardianServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListUsers",
			Handler:    _Guardian_ListUsers_Handler,
		},
		{
			MethodName: "GetUser",
			Handler:    _Guardian_GetUser_Handler,
		},
		{
			MethodName: "ListGroups",
			Handler:    _Guardian_ListGroups_Handler,
		},
		{
			MethodName: "GetGroup",
			Handler:    _Guardian_GetGroup_Handler,
		},
		{
			MethodName: "ListClients",
			Handler:    _Guardian_ListClients_Handler,
		},
		{
			MethodName: "GetClient",
			Handler:    _Guardian_GetClient_Handler,
		},
		{
			MethodName: "CreateClient",
			Handler:    _Guardian_CreateClient_Handler,
		},
		{
			MethodName: "UpdateClient",
			Handler:    _Guardian_UpdateClient_Handler,
		},
		{
			MethodName: "DeleteClient",
			Handler:    _Guardian_DeleteClient_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "code.justin.tv/release/trace/internal/ext/guardian_v1/guardian.proto",
}

func init() {
	proto.RegisterFile("code.justin.tv/release/trace/internal/ext/guardian_v1/guardian.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1191 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x98, 0x4d, 0x6f, 0xdc, 0xc4,
	0x1f, 0xc7, 0x65, 0x67, 0x1f, 0x7f, 0xbb, 0x49, 0x93, 0xd9, 0xfc, 0x2b, 0xd7, 0x7f, 0x90, 0x82,
	0x11, 0x28, 0xea, 0xc1, 0x56, 0x17, 0x71, 0xe1, 0x49, 0x2a, 0x49, 0x9a, 0x52, 0x10, 0x0f, 0x6e,
	0x7b, 0x00, 0x0e, 0x2b, 0xc7, 0x9e, 0x6e, 0x26, 0xda, 0xb5, 0xcd, 0xcc, 0x78, 0xd5, 0x10, 0x55,
	0x42, 0xdc, 0x38, 0x57, 0x42, 0x42, 0xe2, 0xcc, 0x1b, 0x40, 0x85, 0x0b, 0x12, 0xe2, 0xca, 0x81,
	0x0b, 0x6f, 0x81, 0x0b, 0xef, 0x02, 0xcd, 0xc3, 0x7a, 0xed, 0x64, 0x2b, 0x22, 0x3b, 0x1c, 0xaa,
	0xf4, 0x14, 0xcf, 0xd8, 0xfe, 0xce, 0x77, 0x3e, 0xf3, 0xf5, 0xcc, 0x2f, 0x0b, 0xbb, 0x61, 0x12,
	0x61, 0xf7, 0x28, 0x63, 0x9c, 0xc4, 0x2e, 0x9f, 0x79, 0x14, 0x4f, 0x70, 0xc0, 0xb0, 0xc7, 0x69,
	0x10, 0x62, 0x8f, 0xc4, 0x1c, 0xd3, 0x38, 0x98, 0x78, 0xf8, 0x21, 0xf7, 0xc6, 0x59, 0x40, 0x23,
	0x12, 0xc4, 0xa3, 0xd9, 0x8d, 0xfc, 0xda, 0x4d, 0x69, 0xc2, 0x13, 0xf4, 0xba, 0x50, 0x19, 0x29,
	0x95, 0x11, 0x9f, 0xb9, 0x5a, 0xc5, 0x95, 0x2a, 0xee, 0x5c, 0xc5, 0xc5, 0x0f, 0xb9, 0x9b, 0xbf,
	0x39, 0xbb, 0x61, 0xbf, 0x30, 0x4e, 0x92, 0xf1, 0x04, 0x7b, 0x41, 0x4a, 0xbc, 0x20, 0x8e, 0x13,
	0x1e, 0x70, 0x92, 0xc4, 0x4c, 0x89, 0xda, 0xff, 0xd7, 0x77, 0x65, 0xeb, 0x20, 0x7b, 0xe0, 0xe1,
	0x69, 0xca, 0x8f, 0xd5, 0x4d, 0xe7, 0x77, 0x13, 0x1a, 0xf7, 0x19, 0xa6, 0x68, 0x0d, 0x4c, 0x12,
	0x59, 0xc6, 0x96, 0xb1, 0xdd, 0xf5, 0x4d, 0x12, 0x21, 0x04, 0x0d, 0x7e, 0x9c, 0x62, 0xcb, 0x94,
	0x3d, 0xf2, 0x1a, 0x3d, 0x00, 0x08, 0x38, 0xa7, 0xe4, 0x20, 0xe3, 0x98, 0x59, 0x2b, 0x5b, 0xc6,
	0x76, 0x6f, 0x78, 0xcb, 0xad, 0xe4, 0xd9, 0x15, 0x83, 0xba, 0x37, 0x73, 0x35, 0xbf, 0xa0, 0x6c,
	0x3f, 0x31, 0x00, 0x16, 0xb7, 0xd0, 0x3a, 0xac, 0x64, 0xb9, 0x37, 0x71, 0x89, 0x5e, 0x04, 0xc8,
	0x48, 0x34, 0x8a, 0xb3, 0xe9, 0x01, 0xa6, 0xd2, 0x62, 0xd3, 0xef, 0x66, 0x24, 0xfa, 0x50, 0x76,
	0xa0, 0x4d, 0x68, 0xe2, 0x69, 0x40, 0x26, 0xd2, 0x62, 0xd7, 0x57, 0x0d, 0x31, 0xc3, 0x30, 0xb6,
	0x1a, 0x6a, 0x86, 0x61, 0x2c, 0x44, 0xc6, 0x0b, 0x91, 0xa6, 0x12, 0x19, 0xe7, 0x22, 0xd7, 0xa0,
	0x73, 0x98, 0x4c, 0xf1, 0x28, 0x22, 0xd4, 0x6a, 0xc9, 0x97, 0xda, 0xa2, 0xbd, 0x4b, 0x28, 0xba,
	0x0a, 0xad, 0x31, 0x4d, 0xb2, 0x94, 0x59, 0xed, 0xad, 0x95, 0xed, 0xae, 0xaf, 0x5b, 0xce, 0x57,
	0x26, 0x34, 0xf7, 0xc5, 0xe5, 0xb9, 0x68, 0x8e, 0x97, 0xd0, 0xdc, 0xaf, 0x48, 0x53, 0x8e, 0xfa,
	0x34, 0x9c, 0x47, 0xa7, 0x69, 0x8e, 0xb5, 0xb7, 0xa6, 0x2f, 0x2e, 0x35, 0x18, 0x33, 0x07, 0xb3,
	0x05, 0xbd, 0x08, 0xb3, 0x90, 0x92, 0x54, 0xc4, 0x48, 0x43, 0x2c, 0x76, 0x21, 0x0b, 0xda, 0x53,
	0x2c, 0x28, 0x31, 0xab, 0x21, 0x09, 0xcc, 0x9b, 0xce, 0xaf, 0x2b, 0xd0, 0xda, 0x99, 0x10, 0x1c,
	0xf3, 0x73, 0x31, 0x38, 0x5c, 0xc2, 0xe0, 0x76, 0x45, 0x06, 0x6a, 0xd8, 0xa7, 0x41, 0xf8, 0xc1,
	0x2c, 0x51, 0x58, 0x62, 0x2e, 0x0e, 0xa6, 0xb9, 0x39, 0x71, 0x7d, 0x3e, 0x0e, 0x33, 0x4c, 0x99,
	0xb8, 0xab, 0x72, 0x35, 0x6f, 0x22, 0x07, 0xfa, 0x14, 0x47, 0x84, 0xe2, 0x90, 0x8f, 0x32, 0x4a,
	0x64, 0xbc, 0xba, 0x7e, 0xa9, 0x0f, 0xd9, 0x2a, 0x61, 0x69, 0x30, 0xc6, 0x3a, 0x61, 0x79, 0x5b,
	0x8c, 0xcd, 0x70, 0x48, 0x31, 0x1f, 0x1d, 0x06, 0xec, 0xd0, 0x6a, 0xab, 0xb1, 0x0b, 0x5d, 0xe8,
	0x55, 0x58, 0x13, 0x7f, 0x47, 0xc1, 0x64, 0x9c, 0x50, 0xc2, 0x0f, 0xa7, 0x56, 0x47, 0x3e, 0x74,
	0xaa, 0x57, 0x84, 0x95, 0x85, 0x49, 0x8a, 0x99, 0xd5, 0x55, 0x61, 0x55, 0xad, 0x42, 0x88, 0xa1,
	0x14, 0xe2, 0x97, 0xa1, 0x7d, 0x87, 0x25, 0xf1, 0xcd, 0x94, 0x14, 0xa7, 0x67, 0x94, 0xa6, 0xe7,
	0xfc, 0x61, 0x40, 0x73, 0x8f, 0xd2, 0x44, 0x7e, 0x6b, 0x9c, 0xf0, 0x09, 0xd6, 0x4f, 0xa8, 0x86,
	0x10, 0x8f, 0x30, 0x17, 0x9f, 0xa0, 0x02, 0xaa, 0x5b, 0xd2, 0x0c, 0x0f, 0x78, 0xc6, 0x34, 0x4d,
	0xdd, 0x42, 0x9f, 0x43, 0x8b, 0x25, 0x19, 0x0d, 0xb1, 0xe4, 0xd8, 0x1b, 0xee, 0x54, 0xcc, 0x80,
	0xf4, 0xe4, 0xde, 0x95, 0x52, 0xbe, 0x96, 0xb4, 0x1d, 0x68, 0xa9, 0x1e, 0x31, 0xa1, 0x34, 0x91,
	0x2f, 0xcf, 0x27, 0xa4, 0x9b, 0x0e, 0x82, 0xf5, 0x0f, 0x08, 0xe3, 0x62, 0x57, 0x62, 0x3e, 0xfe,
	0x22, 0xc3, 0x8c, 0x3b, 0xdf, 0x9a, 0xb0, 0x51, 0xe8, 0x64, 0x69, 0x12, 0x33, 0x8c, 0x3e, 0x86,
	0x66, 0x26, 0x3a, 0x2c, 0x63, 0x6b, 0x65, 0xbb, 0x37, 0x7c, 0xb3, 0xc6, 0xfe, 0xe7, 0x37, 0xa2,
	0x80, 0x07, 0xe8, 0x53, 0xe8, 0x1c, 0xb1, 0x24, 0x1e, 0x05, 0x29, 0x91, 0xb8, 0x7a, 0xc3, 0x77,
	0x2a, 0x8a, 0xea, 0x85, 0xf3, 0xdb, 0x42, 0x2f, 0x48, 0x09, 0xba, 0x07, 0x2d, 0x2c, 0x90, 0x08,
	0xde, 0xc2, 0xed, 0x5b, 0x75, 0xb8, 0xfa, 0x5a, 0xcb, 0x71, 0x60, 0x6d, 0x1f, 0x4b, 0x2c, 0x1a,
	0xd5, 0xd9, 0x2d, 0xda, 0x79, 0x6c, 0xc2, 0x95, 0xfc, 0x21, 0x8d, 0xee, 0x23, 0x68, 0x08, 0x74,
	0xf2, 0xb1, 0xcb, 0x49, 0x6e, 0xa0, 0x12, 0x25, 0xb7, 0xeb, 0x3c, 0x67, 0xdf, 0x99, 0x80, 0x8a,
	0xbd, 0x9a, 0x96, 0x9f, 0x7f, 0xa0, 0x46, 0x2d, 0x07, 0x52, 0xf6, 0x59, 0x05, 0xf6, 0x92, 0x4c,
	0x91, 0x9a, 0x82, 0xce, 0x9a, 0x3a, 0xae, 0x8c, 0xf9, 0x71, 0x25, 0x3e, 0xd3, 0xf5, 0xc5, 0x33,
	0x1a, 0xde, 0x27, 0xd0, 0x94, 0xf0, 0x74, 0xd6, 0x2e, 0x25, 0xbb, 0x4d, 0x15, 0x2b, 0x75, 0x2e,
	0xe6, 0x69, 0xfb, 0xde, 0x84, 0x41, 0xa9, 0x5b, 0x13, 0xbb, 0x07, 0xed, 0x50, 0x75, 0xe9, 0xbc,
	0xbd, 0x5d, 0xeb, 0x1c, 0x7e, 0x76, 0xf7, 0x36, 0x11, 0x26, 0x3d, 0x87, 0x45, 0xe2, 0x8a, 0xc5,
	0x82, 0xf8, 0x60, 0x37, 0x0a, 0x0f, 0x69, 0x80, 0x77, 0xa1, 0xa5, 0x00, 0xea, 0xcc, 0x5d, 0x4e,
	0x7e, 0x47, 0x30, 0xd8, 0xa1, 0x38, 0xe0, 0xb8, 0x8c, 0xf0, 0xbf, 0x80, 0x23, 0xa2, 0xbc, 0x59,
	0x1e, 0xec, 0xf9, 0x52, 0x14, 0x96, 0xe2, 0x4b, 0x18, 0xdc, 0x4f, 0xa3, 0x33, 0x4b, 0x71, 0xba,
	0xf4, 0x5d, 0xc0, 0x32, 0x2f, 0x76, 0x69, 0xca, 0x83, 0x3f, 0x5f, 0x9a, 0xc2, 0xd2, 0xbc, 0x02,
	0x83, 0x5d, 0x3c, 0xc1, 0xff, 0xb2, 0x34, 0xc3, 0xbf, 0xfb, 0xd0, 0xd9, 0xd7, 0x22, 0xe8, 0x47,
	0x03, 0xba, 0x79, 0x39, 0x8a, 0xaa, 0xfe, 0xa7, 0x78, 0xba, 0xca, 0xb5, 0x6f, 0xd7, 0x17, 0x52,
	0x4b, 0xeb, 0x0c, 0xbe, 0xfe, 0xf3, 0xaf, 0xc7, 0xe6, 0x2a, 0xea, 0x79, 0x93, 0x28, 0x48, 0x3d,
	0x59, 0x25, 0x0b, 0xd7, 0x6d, 0x5d, 0x07, 0xa2, 0xbd, 0xaa, 0xa7, 0x70, 0xa9, 0xd8, 0xb4, 0x6f,
	0xd5, 0x95, 0xd1, 0x7e, 0xaf, 0x49, 0xbf, 0x03, 0xb4, 0x51, 0xf0, 0xeb, 0x9d, 0x64, 0x24, 0x7a,
	0x84, 0x7e, 0x36, 0x00, 0x16, 0x25, 0x19, 0xaa, 0xc3, 0xa8, 0x54, 0xeb, 0xd9, 0xef, 0x5d, 0x80,
	0x92, 0xb6, 0xbf, 0x29, 0xed, 0xaf, 0xa1, 0xbe, 0xb2, 0xaf, 0x6a, 0x45, 0xf4, 0x93, 0x01, 0x9d,
	0x79, 0x35, 0x84, 0x6a, 0x90, 0x2a, 0x96, 0x5c, 0xf6, 0x7e, 0x6d, 0x9d, 0xe5, 0xc8, 0x95, 0x67,
	0xef, 0x24, 0x8c, 0x1f, 0x09, 0xe3, 0xbd, 0x42, 0x5d, 0x82, 0xea, 0x90, 0x2a, 0x97, 0x3c, 0xf6,
	0x9d, 0x8b, 0x90, 0xd2, 0x33, 0x58, 0x97, 0x33, 0x00, 0xd4, 0xf1, 0x74, 0xb5, 0x84, 0x9e, 0x18,
	0xd0, 0xcd, 0xab, 0x01, 0x54, 0x03, 0x55, 0x69, 0x2f, 0xa8, 0xfc, 0x5d, 0x9e, 0x29, 0x4c, 0x9c,
	0xff, 0x49, 0xcb, 0x57, 0xd0, 0xea, 0xdc, 0xb2, 0x77, 0x22, 0x32, 0xfe, 0x8b, 0x01, 0xfd, 0xe2,
	0xe9, 0x89, 0xaa, 0x62, 0x5a, 0x72, 0xde, 0xdb, 0xef, 0x5f, 0x88, 0x56, 0x79, 0x63, 0x71, 0x72,
	0xe6, 0x6f, 0x18, 0xd7, 0xd1, 0x6f, 0x06, 0xf4, 0x8b, 0x27, 0x4c, 0x65, 0xfb, 0x4b, 0xce, 0xc8,
	0xca, 0xf6, 0x97, 0x1d, 0x79, 0x8e, 0x25, 0xed, 0xa3, 0x61, 0x99, 0xbf, 0x98, 0xc3, 0x37, 0x06,
	0xf4, 0x8b, 0xe7, 0x40, 0xe5, 0x39, 0x2c, 0x39, 0x4c, 0xec, 0xab, 0xae, 0xfa, 0xe1, 0xd7, 0x9d,
	0xff, 0xf0, 0xeb, 0xee, 0x4d, 0x53, 0x7e, 0x3c, 0x8f, 0xc3, 0xf5, 0xb2, 0x9d, 0x77, 0x57, 0x3f,
	0xeb, 0x15, 0x7e, 0x99, 0x3e, 0x68, 0xc9, 0xb7, 0x5e, 0xfb, 0x27, 0x00, 0x00, 0xff, 0xff, 0xc7,
	0xb2, 0x43, 0xe7, 0xd9, 0x16, 0x00, 0x00,
}
