![Twirp Logo](./logo.png)

---

Twirp is Twitch's RPC system.

Define your service in a [Profobuf](https://developers.google.com/protocol-buffers/docs/proto3) file
and then Twirp autogenerates Go code with a server interface and fully functional clients. It is
similar to [gRPC](http://www.grpc.io/), but designed to integrate easily with Twitch infrastructure
(i.e. it can run on HTTP 1.1, not just http/2).

Twirp handles routing and serialization for you in a well-tested, standardized, thoughtful way so you
don't have to. Serialization and deserialization code is error-prone and tricky, and you shouldn't be
wasting your time deciding whether it should be "POST /follows/:id/new" or "POST /:id/follows" or whatever.
Just get to the real work of building services!

Along the way, you get an autogenerated client and a simple, smart framework for passing error messages. Nice!

### Wiki
Documentation, install instructions, usage examples, implementation details, ... [Twirp Wiki](https://git-aws.internal.justin.tv/common/twirp/wiki).

### Releases
Twirp versions and upgrade guides: [Twirp Releases](https://git-aws.internal.justin.tv/common/twirp/releases)

### Projects using Twirp
This is a (possibly incomplete) list of projects using Twirp in production today:

 - [video/almanac](https://git-aws.internal.justin.tv/video/almanac) (in two places: [api](https://git-aws.internal.justin.tv/video/almanac/blob/master/cmd/almanac/api/v1) and [flowsdproxy](https://git-aws.internal.justin.tv/video/almanac/tree/master/cmd/flowsdproxy/api/v1))
 - [video/digestion](https://git-aws.internal.justin.tv/video/digestion)
 - [video/replicator](https://git-aws.internal.justin.tv/video/replicator)
 - [video/goingest](https://git-aws.internal.justin.tv/video/goingest)
 - [video/weaver](https://git-aws.internal.justin.tv/video/weaver)
 - [video/chukwa](https://git-aws.internal.justin.tv/video/chukwa)
 - [video/channel_properties](https://git-aws.internal.justin.tv/video/channel_properties)
 - [feeds/following-service](https://git-aws.internal.justin.tv/feeds/following-service)
 - [ads/fring](https://git-aws.internal.justin.tv/ads/fring)
 - [ads/dads](https://git-aws.internal.justin.tv/ads/dads)
 - [commerce/tachanka](https://git-aws.internal.justin.tv/commerce/tachanka)
 - [commerce/mako](https://git-aws.internal.justin.tv/commerce/mako)
 - [release/trace](https://git-aws.internal.justin.tv/release/trace)
 - [identity/rbac](https://git-aws.internal.justin.tv/identity/rbac)
 - [gds/gds/portal/dpp](https://git-aws.internal.justin.tv/gds/gds/tree/master/portal/dpp)

### Contributing
Check out [CONTRIBUTING.md](./CONTRIBUTING.md) for notes on making contributions.
