# twerk

`twerk` is a command-line utility for performing various QE tasks.

## Requirements
* go `^1.7.4`

## Installation
Simply run:
```
go get -u code.justin.tv/qe/twerk
```

If you're adding this to a build script, then it's recommended that you use apt-get instead:
```
apt-get install twerk
```

You should now be able to run `twerk` from anywhere via the command-line.  Run:

```
twerk -h
```

If you see help output, then you should be good to go.

## Usage
Twerk has a collection of subcommands within.  You can run `twerk -h` to see what these commands are and what args they take.  They are also listed below:

### `get_tests`
Provided a list of [JUnit](http://llg.cubic.org/docs/junit/) `.xml` files, this command will merge the files into one `test_report.xml` which will be in our [internal JUnit format](https://twitchtv.atlassian.net/wiki/display/QE/Reporting+Test+Results#ReportingTestResults-FormatofourTestReports).  If a directory is provided in the list, then it will recursively scan the directory for `.xml` files and merge those into the final file as well.  Any files that fail to merge into the file will be skipped.

#### Custom Output Path:
The `test_report.xml` is generated in the current working directory.  You can specify an alternate path to generate the file in by using the `--output` arg like below:

```
twerk get-tests my/test/dir                   # Will create test_report.xml
twerk get-tests my/test/dir --output dir_path # Will create dir_path/test_report.xml
```

Note that no filename is included when using this arg - **the file will always be generated as `test_report.xml`**

#### Test Type:
You may also pass a flag with a path to specify what type of tests are within the path.  By default, tests are assumed to be of type `UNIT`.  The possible type flags are as follows:

* `--unit` Will set the type of all tests to `UNIT`
* `--int` Will set the type of all tests to `INTEGRATION`
* `--e2e` Will set the type of all tests to `E2E`

##### Example usage:

```
twerk get-tests file1 file2 file3
```
In this example, all 3 files will be of type `UNIT`.

```
twerk get-tests file1 --int file2 --int file3
```
In this example, `file2` and `file3` are both `INTEGRATION`.

```
twerk get-tests dir1 --int file2 --e2e file3 file4 --int file5
```
In this example, everything within `dir1` and `file4` will be of type `UNIT`.  `file2` and `file5` are both `INTEGRATION`, while file3 is `E2E`.
