freeStyleJob('qe-twerk') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'qe/twerk', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    preBuildCleanup()
    timestamps()
    environmentVariables {
      env('ENVIRONMENT', 'development')
    }
  }

  steps {
    shell 'rm -rf .manta/ test_report.xml'
    shell 'manta -v'
    // shell 'cp .manta/test_report.xml test_report.xml'
  }
  publishers {
    reportQuality( 'qe/twerk', '.manta')
  }
}

freeStyleJob('qe-twerk-aptly') {
    parameters {
        stringParam 'GIT_COMMIT'
    }
    steps {
        downloadDeployArtifact 'qe/twerk'
        uploadDeb 'twerk.deb', ['trusty', 'precise']
    }
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'dta_tools_deploy', 'dta_tools_deploy'
        }
    }
}
