package main

import (
	"code.justin.tv/qe/twitchExplore/internal/db"
	"code.justin.tv/qe/twitchExplore/internal/directory"
	"code.justin.tv/qe/twitchExplore/internal/resolvers"
	"flag"
	"log"
	"strings"
)

func main() {
	rootDirectory := flag.String("root", "", "The rootDirectory where all"+
		" the twitch repos are downloaded")
	flag.Parse()

	repos, err := directory.GoRepos(*rootDirectory)
	if err != nil {
		log.Printf("Unable to fetch repos from given root directory %v with err %v", *rootDirectory, err)
		return
	}
	log.Printf("target repos: %v", repos)

	var successfulRepos []string
	var unsuccessfulRepos []string
	for _, repo := range repos {
		log.Printf("Attempting parse of %v", repo)
		deps, err := resolvers.ParseDependencies(repo)
		if err != nil {
			log.Printf("failure to parse due to %v", err.Error())
			unsuccessfulRepos = append(unsuccessfulRepos, repo)
		} else {
			log.Printf("Dependencies found are %v", deps)
			successfulRepos = append(successfulRepos, repo)
			shortRepo := strings.TrimPrefix(repo, *rootDirectory)
			shortRepo = "code.justin.tv" + shortRepo
			err := db.CreateDepRelationships(shortRepo, deps)
			if err != nil {
				log.Printf("Unable to add dep relationship")
				log.Printf("%v", err)
				return
			}
		}
	}
	log.Printf("Complete resolution of dependencies")
	log.Printf("had %v successful", len(successfulRepos))
	log.Printf("had %v failiure", len(unsuccessfulRepos))
}
