package main

import (
    "code.justin.tv/qe/twitchExplore/internal/ldap"
"flag"
"log"
)

func main() {
    user := flag.String("user", "", "Username to look for")
    allUsers := flag.Bool("allUsers", false, "if true, get all users")
    flag.Parse()

    client, err := ldap.NewClient()
    if err != nil {
        log.Println("encountered error while trying to connect to ldap", err.Error())
    }

    if *allUsers {
        result, err := client.GetAllUserInfo()
        log.Println(result)
        if err != nil {
            log.Println(err.Error())
        }
    } else {
    result, err := client.GetUserInfoByName(*user)
    if err != nil {
    log.Println("Could not resolve user", err.Error())
    }
    log.Println(result)
    }
}
