package db

import (
	"strings"
)

func CreateIfNotExistDepNode(dep string) error {
	components := strings.Split(dep, `/`)
	source := components[0]
	org := ""
	short := source
	if len(components) > 1 {
		org = components[1]
	}
	if len(components) > 2 {
		short = components[2]
	}

	conn, err := Connect()
	if err != nil {
		return err
	}
	defer conn.Close()

	query, err := conn.PrepareNeo("MERGE (`{name}`:Repo {source:{source}, org:{org}, repo:{repo}, " +
		"short_name:{short}})")
	if err != nil {
		return err
	}
	_, err = query.ExecNeo(map[string]interface{}{
		"repo":   dep,
		"source": source,
		"org":    org,
		"short":  short,
		"name":   short,
	})
	if err != nil {
		return err
	}
	return nil
}
