package db

import "fmt"

func CreateDepRelationships(repo string, deps []string) error {
	CreateIfNotExistDepNode(repo)
	for _, dep := range deps {
		CreateIfNotExistDepNode(dep)
		err := CreateDepRelationship(repo, dep)
		if err != nil {
			return err
		}
	}
	return nil
}

func CreateDepRelationship(repo string, dep string) error {
	conn, err := Connect()
	if err != nil {
		return err
	}
	defer conn.Close()

	query := fmt.Sprintf(
		`match (A:Repo {repo:'%v'})
        match (B:Repo {repo: '%v'})
        merge (A)-[:DependsOn]->(B)`, repo, dep)

	_, err = conn.ExecNeo(query, map[string]interface{}{})
	if err != nil {
		return err
	}
	return nil
}
