package ldap

import (
    "testing"
)

type CNTest struct {
    DN string
    ExpectedCN string

}

func TestExtractCNFromDN(t *testing.T) {
    testCases := []CNTest{
        {
            DN: `cn=Jonathan Simpson-Bint,ou=Users,dc=justin,dc=tv`,
            ExpectedCN: `Jonathan Simpson-Bint`,
        },
        {
            DN: `cn=Mark Weiler (mweiler),ou=Users,dc=justin,dc=tv`,
            ExpectedCN: `Mark Weiler (mweiler)`,
        },
        {
            DN: `cn=BrandonD. Ove,ou=Users,dc=justin,dc=tv`,
            ExpectedCN: `BrandonD. Ove`,
        },
        {
            DN: `cn=Chris Milward,ou=Users,dc=justin,dc=tv`,
            ExpectedCN: `Chris Milward`,
        },
    }
    
    for _, testCase := range testCases {
        if cn, err := extractCNFromDN(testCase.DN); err != nil || cn != testCase.ExpectedCN {
            t.Fatal("Was unable to parse Username from LDAP. TestCase was", testCase, err)
        }
    }
}