const dateHelper = require('../utils/DateHelper');

class BrowserHelper {
    /**
     * Return the WebElement Object
     * @param selector
     */
    element(selector) {
        return browser.element(selector);
    }

    /**
     * Scroll to a WebElement
     * @param webElement
     * @param xOffset
     * @param yOffset
     */
    scrollTo(selector, xOffset = 0, yOffset = 0) {
        browser.scroll(selector, xOffset, yOffset);
    }

    /**
     * Wait for WebElement to visible/invisible
     * @param selector
     * @param timeout
     * @param reverse
     * @returns boolean
     */
    waitForVisible(selector, timeout = 1000, reverse = false) {
        return browser.waitForVisible(selector, timeout, reverse);
    }

    executeAsync(script, args = null, timeout = 30000) {
        const sTimeStamp = dateHelper.makeHmsFormat();
        try {
            if (browser.options.cdp) {
                browser.timeouts({type: 'script', ms: timeout});
            } else {
                browser.timeouts({'script': timeout});
            }
            let result = null;
            if (args !== null) {
                result = browser.executeAsync(script, args);
            } else {
                result = browser.executeAsync(script);
            }
            return result.value;
        } catch (e) {
            e['sTimestamp'] = sTimeStamp;
            e['eTimestamp'] = dateHelper.makeHmsFormat();
            console.log('==============================================================================================================================');
            console.log(`Failing Script: ${script}`);
            console.log('==============================================================================================================================');
            console.log(`Script started at: ${e.sTimestamp} and finsihed at: ${e.eTimestamp}`);
            console.log('==============================================================================================================================');
            return false;
        }
    }

    execute(script, args, timeout = 30000) {
        const sTimeStamp = dateHelper.makeHmsFormat();
        try {
            if (browser.options.cdp) {
                browser.timeouts({type: 'script', ms: timeout});
            } else {
                browser.timeouts({'script': timeout});
            }
            let result = browser.execute(script, args);
            return result.value;
        } catch (e) {
            e['sTimestamp'] = sTimeStamp;
            e['eTimestamp'] = dateHelper.makeHmsFormat();
            console.log('==============================================================================================================================');
            console.log(`Failing Script: ${script}`);
            console.log('==============================================================================================================================');
            console.log(`Script started at: ${e.sTimestamp} and finsihed at: ${e.eTimestamp}`);
            console.log('==============================================================================================================================');
            throw e;
        }
    }
}
module.exports = new BrowserHelper();
