'use strict';
const _ = require('lodash');
var request = require('sync-request');

const defaultConfig = {
  browserMob: {host: 'localhost', port: 8080, protocol: 'http'}
};

class BrowserMobClient {
  constructor (config) {
    _.defaults(this, config || {}, defaultConfig);
    let bmp = this.browserMob;
    bmp.uri = `${bmp.protocol}://${bmp.host}:${bmp.port}`;
  }

  static createClient (config) {
    return new this(config);
  }

  createHar (options) {
    return this._callProxy('har', 'PUT', options);
  }

  getHar () {
    let response = this._callProxy('har', 'GET');
    return response;
  }

  closeProxies () {
    let that = this;
    return this.listProxies()
      .then(ports => {
        return Promise.all(
          _.map(ports.proxyList, function (portData) {
            return that.end(portData.port);
          })
        );
      });
  }

  setLimits (options) {
    let that = this;
    let response = that._callProxy('limit', 'PUT', options);
    that.limits = options;
    return response;
  }

  setBlackList (options) {
    let that = this;
    let response = that._callProxy('blacklist', 'PUT', options);
    that.limits = options;
    return response;
  }

  start (options) {
    let that = this;
    let resp = that.callRest('proxy', 'POST', options);
    resp = JSON.parse(resp);
    that.port = resp['port'];
    return resp;
  }

  end (port) {
    let that = this;
    if (!port && !that.proxy) { return Promise.resolve(); }
    return this._callProxy(null, 'DELETE', null, port);
  }

  listProxies () {
    return this.callRest('proxy', 'GET');
  }

  callRest (url, method, data) {
    let response = request(method, `${this.browserMob.uri}/${url}`, {qs: data || {}});
    return response.getBody('UTF8');
  }

  _callProxy (ext, method, data, proxyPort) {
    let url = `proxy/${proxyPort || this.port}/${ext || ''}`;
    return this.callRest(url, method, data);
  }
}

module.exports = BrowserMobClient;
