'use strict';
const browserHelper = require('../base/BrowserHelper');
const SPINNER = '.tw-loading-spinner';

class Page {
  constructor () {
    this.browserHelper = browserHelper;
  }

  /**
   * Navigate to a URL
   * @param path Url to navigate
   */
  visit (path) {
    if (path.charAt(0) === '/') {
      browser.url('/' + path);
    } else {
      browser.url(path);
    }
  }

  /**
   * Wait for spinner to appear on the UI
   */
  waitForSpinner () {
    this.browserHelper.waitForVisible(SPINNER, 10000);
  }

  /**
   * Wait for the spinner to disappear on the UI
   */
  waitForSpinnerToDisappear () {
    this.spinner.waitForExist(10000, true);
  }

  /**
   * Saves the screenshot.
   * @param filename Name of the screenshot
   */
  takeScreenshot (screenshotName) {
    // receive screenshot as Buffer
    browser.saveScreenshot(screenshotName);
  }

  /**
   * Return the page title
   * @returns {*}
   */
  getPageTitle () {
    return browser.getTitle();
  }
}

module.exports = Page;
