var request = require('sync-request');
var asyncRequest =  require('request');

class RequestHelper {

    /**
    * Makes synchronous request
    * @param method
    * @param url
    * @param headers
    * @param data
    * @param timeout
    */
    static makeSyncRequest(method, url, headers = {}, data = {}, timeout = 10000) {
        let makeRequest = request(method, url, {
            headers:headers,
            json: data,
            timeout: timeout
        });
        makeRequest.body = makeRequest.getBody('utf-8');
        return makeRequest;
    }

    /**
    * Makes asynchronous request.
    * @param method
    * @param url
    * @param headers
    * @param data
    * @param callback
    */
    static makeAsyncRequest(method, url, headers = {}, data = {}, body = {}, callback= null) {
        let makeRequest = {
            url: url,
            method: method,
            headers,
            json: body,
        };
        asyncRequest(makeRequest,function (error, response, body) {
            if (response && response.statusCode === 200) {
                return body;
            } else {
                throw `Async Request failed for ${makeRequest.url} due to ${JSON.stringify(body)}`
            }
        });
    }
}

module.exports = RequestHelper;
