'use strict';
const requestHelper = require('./RequestHelper');
const uri = 'https://testrail.internal.justin.tv/index.php?/api/v2/';
const headers = {
    'Content-Type': 'application/json',
    Authorization: `Basic ${process.env.PC_UITF_TESTRAIL_SECRET}`,
    'Connection': 'keep-alive'
};

class TestRailHelper {
    /*
    * =================================Project==================================
    */

    getProject(projectId) {
        let relativePath = `${uri}get_project/${projectId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    getProjects() {
        let relativePath = `${uri}get_projects`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    /*
    * ==================================Plans===================================
    */

    getPlan(planId) {
        let relativePath = `${uri}get_plan/${planId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    getPlans(projectId) {
        let relativePath = `${uri}get_plans/${projectId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    addPlan(projectId, data = {}) {
        let relativePath = `${uri}add_plan/${projectId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers, data);
    }

    addPlanEntry(planId, data = {}) {
        let relativePath = `${uri}add_plan_entry/${planId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers, data);
    }

    closePlan(planId) {
        let relativePath = `${uri}close_plan/${planId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers);
    }

    /*
    * ===================================Runs===================================
    */

    addRun(projectId, data = {'name': `TestRun-${new Date().toJSON().slice(0,16)}`, 'include_all': true}) {
        let relativePath = `${uri}add_run/${projectId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers, data);
    }

    getRun(runId) {
        let relativePath = `${uri}get_run/${runId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    getRuns(projectId) {
        let relativePath = `${uri}get_runs/${projectId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    closeRun(runId) {
        let relativePath = `${uri}close_run/${runId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers);
    }

    deleteRun(runId) {
        let relativePath = `${uri}delete_run/${runId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers);
    }

    /*
    * =================================Sections=================================
    */

    getSection(sectionId) {
        let relativePath = `${uri}get_section/${sectionId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    getSections(projectId, suiteId) {
        let relativePath = `${uri}get_sections/${projectId}&suite_id=${suiteId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    addSection(projectId, data = {}) {
        let relativePath = `${uri}add_section/${projectId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers, data);
    }

    /*
    * ==================================Suites==================================
    */

    getSuite(suiteId) {
        let relativePath = `${uri}get_suite/${suiteId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    getSuites(projectId) {
        let relativePath = `${uri}get_sections/${projectId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    addSuite(projectId, data = {}) {
        let relativePath = `${uri}add_suite/${projectId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers, data);
    }

    /*
    * ==================================Cases===================================
    */

    getCase(caseId) {
        let relativePath = `${uri}get_case/${caseId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    getCases(projectId, suiteId) {
        let relativePath = `${uri}get_cases/${projectId}&suite_id=${suiteId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    addCase(sectionId, data = {}) {
        let relativePath = `${uri}add_case/${sectionId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers, data);
    }

    /*
    * ==================================Status==================================
    */

    getStatuses() {
        let relativePath = `${uri}get_statuses`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    /*
    * ===================================Tests==================================
    */

    getTest(testId) {
        let relativePath = `${uri}get_test/${testId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    getTests(runId) {
        let relativePath = `${uri}get_tests/${runId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    /*
    * ==================================Results=================================
    */

    getResults(testId) {
        let relativePath = `${uri}get_results/${testId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    getResultsForCase(runId, caseId) {
        let relativePath = `${uri}get_results_for_case/${runId}/${caseId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    getResultsForRun(runId) {
        let relativePath = `${uri}get_results_for_run/${runId}`;
        return requestHelper.makeSyncRequest('GET', relativePath, headers);
    }

    addResult(testId, data = {}) {
        let relativePath = `${uri}add_result/${testId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers, data);
    }

    addResultForCase(runId, caseId, data = {}) {
        let relativePath = `${uri}add_result_for_case/${runId}/${caseId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers, data);
    }

    addResults(runId, data = {}) {
        let relativePath = `${uri}add_results/${runId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers, data);
    }

    addResultsForCases(runId, data = {}) {
        let relativePath = `${uri}add_results_for_cases/${runId}`;
        return requestHelper.makeSyncRequest('POST', relativePath, headers, data);
    }

}

module.exports = TestRailHelper;
