"use strict";
const Page = require('../../lib/base/Page');

const VIDEO_CONTAINER = '#videoContainer';
const PLAYER_PAGE_URL = 'http://cvp-web.twitch.tv';
const PLAYER = ".player"


class PlayerPage extends Page {
  constructor() {
    super();
  }

    openPlayerPage(){
        this.visit(PLAYER_PAGE_URL)
    }

    waitForVideoContainer() {
        this.browserHelper.waitForVisible(VIDEO_CONTAINER, 5000);
    }

    streamStarted(streamUrl) {
        let jsScript = function(streamUrl, done) {
            player.setAdInsertionEnabled(false);
            player.addEventListener(PlayerState.PLAYING, function () {
                done(true)
            });
            player.load(streamUrl);
            player.play();
        }
        return this.browserHelper.executeAsync(jsScript, streamUrl)
    }

    getQuality(){
      return this.browserHelper.execute('return player.getQuality();');
    }

    getCurrentQualityName() {
      return this.getQuality()['name']
    }

    setQuality(quality) {
      browser.timeouts({'script': 30000});
      if(quality === this.getCurrentQualityName()){
        return true;
      } else {
          let result = browser.executeAsync(function(quality, done) {
              player.addEventListener(PlayerEvent.QUALITY_CHANGED, function (quality) {
                  done(quality['quality']['name'])
              });
              let all_qualities = player.getQualities();
              console.log(player.getQuality())
              for (let qual in all_qualities) {
                  if (all_qualities[qual]['name'].indexOf(quality) !== -1)
                      player.setQuality(all_qualities[qual])
              }
          }, quality);
          return result.value;
      }
    }

    isAbsQualityChange() {
        console.log("******* Setting the quality as abs*********");
        let jsfunc = function (dummyparam, done) {
            player.addEventListener(PlayerEvent.QUALITY_CHANGED, function () {
                done(true)
            });
            player.setAutoSwitchQuality(true);
            player.seekTo(0);
        };
        return  this.browserHelper.executeAsync(jsfunc, 'dummyparam');
    }

    getPlayerQualities() {
        let quality_names = [];
        let qualities = this.browserHelper.execute('return player.getQualities();');
        for (let quality of qualities) {
            quality_names.push(quality['name']);
        }
        return quality_names;
    }

    visitWithLocalstoreSetting(url){
        this.visit(url)
        if( this.browserHelper.waitForVisible(PLAYER, 5000)){
            browser.execute("localStorage.setItem(\'backend\', JSON.stringify('#{VideoPlayerData.player_type}'))")
            browser.execute('localStorage.setItem(\'lastAdDisplay\', 9999999999999)')
            browser.execute('localStorage.setItem(\'quality\', "")')
            browser.execute('localStorage.setItem(\'quality-bitrate\', 358879)')
            this.visit(url)

        } else {
            console.log('HTML did not load within 5 seconds')
        }
    }
}

module.exports = new PlayerPage();
