PPNAME=${APPNAME:-not-brigade}
ENVIRONMENT=${ENVIRONMENT:-prod}
OWNER=${OWNER:-release}
REGION=${REGION:-us-west-2}
AWS_IAM_ARN=${AWS_IAM_ARN:-arn:aws:iam::673385534282:user/codedeploy-onpremise-user}
AWS_ACCESS_KEY=${AWS_ACCESS_KEY:-AAAAAAAAAAAAAAAAAAAA}
AWS_SECRET_KEY=${AWS_SECRET_KEY:-AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA}

FQDN=`hostname -f`
DATACENTER=`hostname -f | awk -F . ' { print $2 } '`
DOMAIN=`dnsdomainname`

if [ -f '/etc/lsb-release' ] ; then
  . /etc/lsb-release
fi

# Install AWS CLI
sudo pip install awscli

# Register instance with codedeploy
sudo \
  AWS_ACCESS_KEY_ID=${AWS_ACCESS_KEY} \
  AWS_SECRET_ACCESS_KEY=${AWS_SECRET_KEY} \
  aws deploy register \
    --instance-name ${FQDN} \
    --region ${REGION} \
    --iam-user-arn ${AWS_IAM_ARN}

# Add tags
sudo \
  AWS_ACCESS_KEY_ID=${AWS_ACCESS_KEY} \
  AWS_SECRET_ACCESS_KEY=${AWS_SECRET_KEY} \
  aws deploy add-tags-to-on-premises-instances \
    --tags \
      Key="environment",Value="${ENVIRONMENT}" \
      Key="appname",Value="${APPNAME}" \
      Key="owner",Value="${OWNER}" \
      Key="instance",Value="${OWNER}-${APPNAME}-${ENVIRONMENT}" \
    --instance-names $FQDN \
    --region $REGION

# Install 
cat <<EOF | sudo tee /root/codedeploy.onpremises.yml
---
region: ${REGION}
iam_user_arn: ${AWS_IAM_ARN}
aws_access_key_id: ${AWS_ACCESS_KEY}
aws_secret_access_key: ${AWS_SECRET_KEY}
EOF
sudo \
  AWS_ACCESS_KEY_ID=${AWS_ACCESS_KEY} \
  AWS_SECRET_ACCESS_KEY=${AWS_SECRET_KEY} \
  aws deploy install \
    --config-file /root/codedeploy.onpremises.yml \
    --region ${REGION}

