package gonagios

import (
	"fmt"
	"os"
)

type Nagios struct {
	Status   Status
	logLines []string
}

func NewNagios() *Nagios {
	return &Nagios{
		logLines: []string{},
		Status:   OK,
	}
}

// Exit immediately with status
func (n *Nagios) ExitWithStatus(status Status, message interface{}) {
	fmt.Printf("%s: %s\n", status.Short, message)

	for _, line := range n.logLines {
		fmt.Println(line)
	}

	os.Exit(status.ExitCode)
}

// Exit using the stored status
func (n *Nagios) Exit(message interface{}) {
	n.ExitWithStatus(n.Status, message)
}

func (n *Nagios) Log(lines ...string) {
	for _, line := range lines {
		n.logLines = append(n.logLines, string(line))
	}
}

func (n *Nagios) RaiseStatus(status Status) {
	if n.Status.ExitCode > status.ExitCode {
		n.Status = status
	}
}
