package gonagios

var PossibleStatuses = []Status{
	Unknown,
	Critical,
	Warning,
	OK,
}

type Status struct {
	ExitCode int
	Consul   string
	Short    string
}

var OK = Status{
	ExitCode: 0,
	Consul:   "passing",
	Short:    "OK",
}

var Warning = Status{
	ExitCode: 1,
	Consul:   "warning",
	Short:    "WARN",
}

var Critical = Status{
	ExitCode: 2,
	Consul:   "critical",
	Short:    "CRIT",
}

var Unknown = Status{
	ExitCode: 3,
	Consul:   "unknown",
	Short:    "UNKN",
}
