package main

import "testing"

type testCase struct {
	Input  string
	Answer string
}

func TestAddSuffix(t *testing.T) {
	cases := []testCase{
		{"foobar.sfo01.justin.tv", "foobar.sfo01.justin.tv"},
		{"foobar.sfo01", "foobar.sfo01.justin.tv"},
		{"foobar.sfo01.twitch.tv", "foobar.sfo01.twitch.tv"},
	}

	for _, c := range cases {
		if res := AddSuffix(c.Input); res != c.Answer {
			t.Errorf("AddSuffix(%s) = %s; want %s", c.Input, res, c.Answer)
		}
	}
}

func TestGetDatacenter(t *testing.T) {
	cases := []testCase{
		{"foobar.fra01.justin.tv", "fra01"},
		{"foobar.justin.tv", "sfo01"},
		{"foobar.fra01.twitch.tv", "fra01"},
		{"foobar-001.prod.us-west2.twitch.tv", "us-west2"},
	}

	for _, c := range cases {
		if res := GetDatacenter(c.Input); res != c.Answer {
			t.Errorf("GetDatacenter(%s) = %s; want %s", c.Input, res, c.Answer)
		}
	}
}
