package main

import "testing"

func TestIsServer(t *testing.T) {
	type testCase struct {
		fileName string
		expected bool
	}

	for _, c := range []testCase{
		{"tests/server.json", true},
		{"tests/not-server.json", false},
	} {
		server, err := isServer(c.fileName)
		if err != nil {
			t.Fatalf("got isServer(%q) = %v; want %v", c.fileName, err, c.expected)
		}

		if server != c.expected {
			t.Errorf("got isServer(%q) = %v; want %v", c.fileName, server, c.expected)
		}
	}

}
