job {
	name 'release-consul-alerts'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/consul-alerts', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
	steps {
		shell 'rm -rf .consul-alerts/'
		shell 'manta -v -proxy'
		saveDeployArtifact 'release/consul-alerts', '.manta'
	}
	publishers {
		archiveJunit '.manta/junit_results.xml'
	}
}

job {
		name "release-consul-alerts-deploy"
			parameters {
					stringParam 'GIT_COMMIT'
			}
		steps {
			downloadDeployArtifact 'release/consul-alerts'
			uploadDeb "consul-alerts.deb"
			uploadDirtyDeb "consul-alerts.deb"
		}
		wrappers {
			preBuildCleanup()
			timestamps()
		}
}
